/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.formatting;

import com.pinterest.ktlint.rule.engine.core.api.Rule;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleEditorConfigPropertyKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfig;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.EditorConfigProperty;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.IndentStyleEditorConfigPropertyKt;
import io.github.detekt.psi.KtFilesKt;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.CorrectableCodeSmell;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Location;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SingleAssign;
import io.gitlab.arturbosch.detekt.api.SourceLocation;
import io.gitlab.arturbosch.detekt.api.TextLocation;
import io.gitlab.arturbosch.detekt.formatting.FormattingProvider;
import io.gitlab.arturbosch.detekt.formatting.KtLintLineColCalculator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.ec4j.core.model.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.FileASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.JavaDummyHolder;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0004J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\u001a\u0010*\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030,\u0012\u0004\u0012\u00020'\u0018\u00010+H\u0016J\b\u0010-\u001a\u00020.H\u0002J(\u0010/\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u00100\u001a\u00020'2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u00020)2\u0006\u00102\u001a\u000203H\u0002J\u0010\u00105\u001a\u00020)2\u0006\u00102\u001a\u000203H\u0002J\f\u00106\u001a\u00020)*\u000203H\u0002J\f\u00107\u001a\u00020\u000b*\u000203H\u0002R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fRy\u0010\u0016\u001a)\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00150\u00102-\u0010\u000f\u001a)\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00150\u00108B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR+\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u001d8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u001c\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u00068"}, d2={"Lio/gitlab/arturbosch/detekt/formatting/FormattingRule;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "wrapping", "Lcom/pinterest/ktlint/rule/engine/core/api/Rule;", "getWrapping", "()Lcom/pinterest/ktlint/rule/engine/core/api/Rule;", "isAndroid", "", "()Z", "runAsLateAsPossible", "getRunAsLateAsPossible", "<set-?>", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "offset", "Lkotlin/Pair;", "positionByOffset", "getPositionByOffset", "()Lkotlin/jvm/functions/Function1;", "setPositionByOffset", "(Lkotlin/jvm/functions/Function1;)V", "positionByOffset$delegate", "Lio/gitlab/arturbosch/detekt/api/SingleAssign;", "Lorg/jetbrains/kotlin/psi/KtFile;", "root", "getRoot", "()Lorg/jetbrains/kotlin/psi/KtFile;", "setRoot", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "root$delegate", "issueFor", "Lio/gitlab/arturbosch/detekt/api/Issue;", "description", "", "visit", "", "overrideEditorConfigProperties", "", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfigProperty;", "computeEditorConfigProperties", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/EditorConfig;", "emitFinding", "message", "canBeAutoCorrected", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "beforeVisitChildNodes", "afterVisitChildNodes", "visitASTNodes", "isNotDummyElement", "detekt-formatting"})
@SourceDebugExtension(value={"SMAP\nFormattingRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FormattingRule.kt\nio/gitlab/arturbosch/detekt/formatting/FormattingRule\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,138:1\n216#2,2:139\n13346#3,2:141\n*S KotlinDebug\n*F\n+ 1 FormattingRule.kt\nio/gitlab/arturbosch/detekt/formatting/FormattingRule\n*L\n75#1:139,2\n125#1:141,2\n*E\n"})
public abstract class FormattingRule
extends io.gitlab.arturbosch.detekt.api.Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final SingleAssign positionByOffset$delegate;
    @NotNull
    private final SingleAssign root$delegate;

    public FormattingRule(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.positionByOffset$delegate = new SingleAssign();
        this.root$delegate = new SingleAssign();
    }

    @NotNull
    public abstract Rule getWrapping();

    protected final boolean isAndroid() {
        return (Boolean)FormattingProvider.Companion.getAndroid().value(this.getRuleSetConfig());
    }

    public final boolean getRunAsLateAsPossible() {
        return this.getWrapping().getVisitorModifiers().contains(Rule.VisitorModifier.RunAsLateAsPossible.INSTANCE);
    }

    private final Function1<Integer, Pair<Integer, Integer>> getPositionByOffset() {
        return (Function1)this.positionByOffset$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setPositionByOffset(Function1<? super Integer, Pair<Integer, Integer>> function1) {
        this.positionByOffset$delegate.setValue((Object)this, $$delegatedProperties[0], function1);
    }

    private final KtFile getRoot() {
        return (KtFile)this.root$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setRoot(KtFile ktFile) {
        this.root$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)ktFile);
    }

    @NotNull
    protected final Issue issueFor(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        return new Issue(string, Severity.Style, description, Debt.Companion.getFIVE_MINS());
    }

    public void visit(@NotNull KtFile root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.setRoot(root);
        String string = root.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.setPositionByOffset(KtLintLineColCalculator.INSTANCE.calculateLineColByOffset(KtLintLineColCalculator.INSTANCE.normalizeText(string)));
        this.getWrapping().beforeFirstNode(this.computeEditorConfigProperties());
        FileASTNode fileASTNode = root.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)fileASTNode, (String)"getNode(...)");
        this.visitASTNodes((ASTNode)fileASTNode);
        this.getWrapping().afterLastNode();
    }

    @Nullable
    public Map<EditorConfigProperty<?>, String> overrideEditorConfigProperties() {
        return null;
    }

    private final EditorConfig computeEditorConfigProperties() {
        Map map;
        Map usesEditorConfigProperties;
        Map map2 = this.overrideEditorConfigProperties();
        if (map2 == null || (map2 = MapsKt.toMutableMap(map2)) == null) {
            map2 = usesEditorConfigProperties = (Map)new LinkedHashMap();
        }
        if (this.isAndroid()) {
            usesEditorConfigProperties.put(CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY(), "android_studio");
        } else {
            usesEditorConfigProperties.put(CodeStyleEditorConfigPropertyKt.getCODE_STYLE_PROPERTY(), "intellij_idea");
        }
        usesEditorConfigProperties.put(IndentStyleEditorConfigPropertyKt.getINDENT_STYLE_PROPERTY(), "space");
        Map $this$computeEditorConfigProperties_u24lambda_u241 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Map $this$forEach$iv = usesEditorConfigProperties;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            EditorConfigProperty editorConfigProperty = (EditorConfigProperty)entry.getKey();
            String defaultValue = (String)entry.getValue();
            $this$computeEditorConfigProperties_u24lambda_u241.put(editorConfigProperty.getType().getName(), Property.builder().name(editorConfigProperty.getType().getName()).type(editorConfigProperty.getType()).value(defaultValue).build());
        }
        Map properties = MapsKt.build((Map)map);
        return new EditorConfig(properties);
    }

    private final void emitFinding(int offset, String message, boolean canBeAutoCorrected, ASTNode node) {
        Pair pair = (Pair)this.getPositionByOffset().invoke((Object)offset);
        int line = ((Number)pair.component1()).intValue();
        int column = ((Number)pair.component2()).intValue();
        Location location = new Location(new SourceLocation(line, column), new TextLocation(offset, offset + 1), KtFilesKt.toFilePath((PsiFile)((PsiFile)this.getRoot())));
        PsiElement psiElement = node.getPsi();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
        Entity entity = Entity.Companion.from(psiElement, location);
        if (canBeAutoCorrected) {
            this.report((Finding)new CorrectableCodeSmell(this.getIssue(), entity, message, null, null, this.getAutoCorrect(), 24, null));
        } else {
            this.report((Finding)new CodeSmell(this.getIssue(), entity, message, null, null, 24, null));
        }
    }

    private final void beforeVisitChildNodes(ASTNode node) {
        this.getWrapping().beforeVisitChildNodes(node, this.getAutoCorrect(), (Function3<? super Integer, ? super String, ? super Boolean, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FormattingRule.beforeVisitChildNodes$lambda$2(this, node, arg_0, arg_1, arg_2)));
    }

    private final void afterVisitChildNodes(ASTNode node) {
        this.getWrapping().afterVisitChildNodes(node, this.getAutoCorrect(), (Function3<? super Integer, ? super String, ? super Boolean, Unit>)((Function3)(arg_0, arg_1, arg_2) -> FormattingRule.afterVisitChildNodes$lambda$3(this, node, arg_0, arg_1, arg_2)));
    }

    private final void visitASTNodes(ASTNode $this$visitASTNodes) {
        if (this.isNotDummyElement($this$visitASTNodes)) {
            this.beforeVisitChildNodes($this$visitASTNodes);
        }
        ASTNode[] aSTNodeArray = $this$visitASTNodes.getChildren(null);
        Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
        Object[] $this$forEach$iv = aSTNodeArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode it = (ASTNode)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.visitASTNodes(it);
        }
        if (this.isNotDummyElement($this$visitASTNodes)) {
            this.afterVisitChildNodes($this$visitASTNodes);
        }
    }

    private final boolean isNotDummyElement(ASTNode $this$isNotDummyElement) {
        PsiElement psiElement = $this$isNotDummyElement.getPsi();
        PsiElement parent = psiElement != null ? psiElement.getParent() : null;
        return !(parent instanceof JavaDummyHolder) && !(parent instanceof JavaDummyElement);
    }

    private static final Unit beforeVisitChildNodes$lambda$2(FormattingRule this$0, ASTNode $node, int offset, String errorMessage, boolean canBeAutoCorrected) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this$0.emitFinding(offset, errorMessage, canBeAutoCorrected, $node);
        return Unit.INSTANCE;
    }

    private static final Unit afterVisitChildNodes$lambda$3(FormattingRule this$0, ASTNode $node, int offset, String errorMessage, boolean canBeAutoCorrected) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this$0.emitFinding(offset, errorMessage, canBeAutoCorrected, $node);
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FormattingRule.class, "positionByOffset", "getPositionByOffset()Lkotlin/jvm/functions/Function1;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(FormattingRule.class, "root", "getRoot()Lorg/jetbrains/kotlin/psi/KtFile;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

