/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.List;
import org.ec4j.core.model.Adaptable;
import org.ec4j.core.model.PropertyType;
import org.ec4j.core.model.Section;

public class Property
extends Adaptable {
    private final String name;
    private final PropertyType<?> type;
    private final PropertyType.PropertyValue<?> value;

    public static Builder builder() {
        return new Builder(null);
    }

    Property(List<Object> adapters, PropertyType<?> type, String name, PropertyType.PropertyValue<?> value) {
        super(adapters);
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Property other = (Property)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public String getName() {
        return this.name;
    }

    public String getSourceValue() {
        return this.value.getSource();
    }

    public PropertyType<?> getType() {
        return this.type;
    }

    public <T> T getValueAs() {
        if (this.value.isValid()) {
            return (T)this.value.getParsed();
        }
        throw new RuntimeException(this.value.getErrorMessage());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean isUnset() {
        return this.value.isUnset();
    }

    public boolean isValid() {
        return this.value.isValid();
    }

    public String toString() {
        return this.name + " = " + this.value.getSource();
    }

    public static class Builder
    extends Adaptable.Builder<Builder> {
        String name;
        private final Section.Builder parentBuilder;
        PropertyType<?> type;
        PropertyType.PropertyValue<?> value;

        public Builder(Section.Builder parentBuilder) {
            this.parentBuilder = parentBuilder;
        }

        public Property build() {
            return new Property(this.sealAdapters(), this.type, this.name, this.value);
        }

        public Section.Builder closeProperty() {
            return this.parentBuilder.property(this);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(PropertyType<?> type) {
            this.name = type.getName();
            this.type = type;
            return this;
        }

        public Builder value(PropertyType.PropertyValue<?> value) {
            this.value = value;
            return this;
        }

        public Builder value(String value) {
            if (this.type == null) {
                this.value(PropertyType.PropertyValue.valid(value, value));
            } else {
                this.value(this.type.parse(value));
            }
            return this;
        }
    }
}

