/*
 * Decompiled with CFR 0.152.
 */
package org.ec4j.core.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;

public class PropertyType<T> {
    private static final String[] BOOLEAN_POSSIBLE_VALUES = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    public static final PropertyType<String> charset = new LowerCasingPropertyType<String>("charset", "set to latin1, utf-8, utf-8-bom, utf-16be or utf-16le to control the character set. Use of utf-8-bom is discouraged.", PropertyValueParser.IDENTITY_VALUE_PARSER, "utf-8", "utf-8-bom", "utf-16be", "utf-16le", "latin1", "tab");
    public static final PropertyType<EndOfLineValue> end_of_line = new LowerCasingPropertyType<EndOfLineValue>("end_of_line", "set to lf, cr, or crlf to control how line breaks are represented.", new PropertyValueParser.EnumValueParser<EndOfLineValue>(EndOfLineValue.class), EndOfLineValue.valueSet());
    public static final PropertyType<Integer> indent_size = new LowerCasingPropertyType<Integer>("indent_size", "a whole number defining the number of columns used for each indentation level and the width of soft tabs (when supported). When set to tab, the parsed of tab_width (if specified) will be used.", PropertyValueParser.INDENT_SIZE_VALUE_PARSER, "1", "2", "3", "4", "5", "6", "7", "8", "tab");
    public static final PropertyType<IndentStyleValue> indent_style = new LowerCasingPropertyType<IndentStyleValue>("indent_style", "set to tab or space to use hard tabs or soft tabs respectively.", new PropertyValueParser.EnumValueParser<IndentStyleValue>(IndentStyleValue.class), IndentStyleValue.valueSet());
    public static final PropertyType<Boolean> insert_final_newline = new LowerCasingPropertyType<Boolean>("insert_final_newline", "set to true to ensure file ends with a newline when saving and false to ensure it doesn't.", PropertyValueParser.BOOLEAN_VALUE_PARSER, BOOLEAN_POSSIBLE_VALUES);
    public static final PropertyType<Integer> max_line_length = new LowerCasingPropertyType<Integer>("max_line_length", "forces hard line wrapping after the amount of characters specified. Use the `off` value to turn this feature off (use the editor settings).", PropertyValueParser.MAX_LINE_LENGTH_VALUE_PARSER, "1", "2", "3", "4", "5", "6", "7", "8", "off");
    public static final PropertyType<Boolean> root = new LowerCasingPropertyType<Boolean>("root", "special property that should be specified at the top of the file outside of any sections. Set to true to stop .editorconfig files search on current file.", PropertyValueParser.BOOLEAN_VALUE_PARSER, BOOLEAN_POSSIBLE_VALUES);
    private static final Set<PropertyType<?>> STANDARD_TYPES;
    public static final PropertyType<Integer> tab_width;
    public static final PropertyType<Boolean> trim_trailing_whitespace;
    public static final String unset = "unset";
    private final String description;
    private final String name;
    private final PropertyValueParser<T> parser;
    private final Set<String> possibleValues;

    public static Set<PropertyType<?>> standardTypes() {
        return STANDARD_TYPES;
    }

    private static Set<String> toSet(String[] possibleValues2) {
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        for (String v : possibleValues2) {
            s.add(v);
        }
        return Collections.unmodifiableSet(s);
    }

    public PropertyType(String name, String description, PropertyValueParser<T> parser, Set<String> possibleValues) {
        this.name = name;
        this.description = description;
        this.possibleValues = possibleValues;
        this.parser = parser;
    }

    public PropertyType(String name, String description, PropertyValueParser<T> parser, String ... possibleValues) {
        this(name, description, parser, PropertyType.toSet(possibleValues));
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getPossibleValues() {
        return this.possibleValues;
    }

    public String normalizeIfNeeded(String value) {
        return value;
    }

    public PropertyValue<T> parse(String value) {
        return this.parser.parse(this.name, value);
    }

    public String toString() {
        return this.name;
    }

    static {
        tab_width = new PropertyType<Integer>("tab_width", "a whole number defining the number of columns used to represent a tab character. This defaults to the parsed of indent_size and doesn't usually need to be specified.", PropertyValueParser.POSITIVE_INT_VALUE_PARSER, "1", "2", "3", "4", "5", "6", "7", "8");
        trim_trailing_whitespace = new LowerCasingPropertyType<Boolean>("trim_trailing_whitespace", "set to true to remove any whitespace characters preceding newline characters and false to ensure it doesn't.", PropertyValueParser.BOOLEAN_VALUE_PARSER, BOOLEAN_POSSIBLE_VALUES);
        STANDARD_TYPES = Collections.unmodifiableSet(new LinkedHashSet<PropertyType>(Arrays.asList(charset, end_of_line, indent_size, indent_style, insert_final_newline, root, tab_width, trim_trailing_whitespace)));
    }

    public static interface PropertyValueParser<T> {
        public static final PropertyValueParser<Boolean> BOOLEAN_VALUE_PARSER = new PropertyValueParser<Boolean>(){

            @Override
            public PropertyValue<Boolean> parse(String name, String value) {
                if (value == null) {
                    return PropertyValue.invalid(null, "Property '" + name + "' expects a boolean; found: null");
                }
                if ("true".equalsIgnoreCase(value)) {
                    return PropertyValue.valid(value, Boolean.TRUE);
                }
                if ("false".equalsIgnoreCase(value)) {
                    return PropertyValue.valid(value, Boolean.FALSE);
                }
                if (PropertyType.unset.equalsIgnoreCase(value)) {
                    return PropertyValue.UNSET;
                }
                return PropertyValue.invalid(value, "Property '" + name + "' expects a boolean. The parsed '" + value + "' is not a boolean.");
            }
        };
        public static final PropertyValueParser<String> IDENTITY_VALUE_PARSER = new PropertyValueParser<String>(){

            @Override
            public PropertyValue<String> parse(String name, String value) {
                return PropertyValue.valid(value, value);
            }
        };
        public static final PropertyValueParser<Integer> INDENT_SIZE_VALUE_PARSER = new PropertyValueParser<Integer>(){

            @Override
            public PropertyValue<Integer> parse(String name, String value) {
                if ("tab".equalsIgnoreCase(value)) {
                    return PropertyValue.valid(value, null);
                }
                return POSITIVE_INT_VALUE_PARSER.parse(name, value);
            }
        };
        public static final PropertyValueParser<Integer> MAX_LINE_LENGTH_VALUE_PARSER = new PropertyValueParser<Integer>(){

            @Override
            public PropertyValue<Integer> parse(String name, String value) {
                if ("off".equalsIgnoreCase(value)) {
                    return PropertyValue.valid(value, null);
                }
                return POSITIVE_INT_VALUE_PARSER.parse(name, value);
            }
        };
        public static final PropertyValueParser<Integer> POSITIVE_INT_VALUE_PARSER = new PropertyValueParser<Integer>(){

            @Override
            public PropertyValue<Integer> parse(String name, String value) {
                try {
                    int val = Integer.parseInt(value);
                    if (val <= 0) {
                        return PropertyValue.invalid(value, "Property '" + name + "' expects a positive integer; found '" + value + "'");
                    }
                    return PropertyValue.valid(value, val);
                }
                catch (NumberFormatException e) {
                    return PropertyValue.invalid(value, "Property '" + name + "' expects an integer. The parsed '" + value + "' is not an integer.");
                }
            }
        };

        public PropertyValue<T> parse(String var1, String var2);

        public static class EnumValueParser<T extends Enum<T>>
        implements PropertyValueParser<T> {
            private final Class<? extends Enum> enumType;

            public EnumValueParser(Class<? extends T> enumType) {
                this.enumType = enumType;
            }

            @Override
            public PropertyValue<T> parse(String name, String value) {
                if (value == null) {
                    return PropertyValue.invalid(value, "Cannot make enum " + this.enumType.getName() + " out of null");
                }
                try {
                    return PropertyValue.valid(value, Enum.valueOf(this.enumType, value.toLowerCase()));
                }
                catch (IllegalArgumentException e) {
                    return PropertyValue.invalid(value, "Unexpected parsed \"" + value + "\" for enum " + this.enumType.getName());
                }
            }
        }
    }

    public static class PropertyValue<T> {
        private static final PropertyValue UNSET = new PropertyValue<Object>("unset", null, null);
        private final String errorMessage;
        private final T parsed;
        private final String source;

        public static <T> PropertyValue<T> invalid(String source, String errorMessage) {
            if (PropertyType.unset.equalsIgnoreCase(source)) {
                return UNSET;
            }
            return new PropertyValue<Object>(source, null, errorMessage);
        }

        public static <T> PropertyValue<T> valid(String source, T value) {
            if (PropertyType.unset.equalsIgnoreCase(source)) {
                return UNSET;
            }
            return new PropertyValue<T>(source, value, null);
        }

        PropertyValue(String source, T value, String errorMessage) {
            this.source = source;
            this.parsed = value;
            this.errorMessage = errorMessage;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyValue other = (PropertyValue)obj;
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.parsed == null ? other.parsed != null : !this.parsed.equals(other.parsed)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public T getParsed() {
            return this.parsed;
        }

        public String getSource() {
            return this.source;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            result = 31 * result + (this.parsed == null ? 0 : this.parsed.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean isUnset() {
            return PropertyType.unset.equals(this.source);
        }

        public boolean isValid() {
            return this.errorMessage == null;
        }

        public String toString() {
            return "PropertyValue [errorMessage=" + this.errorMessage + ", parsed=" + this.parsed + ", source=" + this.source + "]";
        }
    }

    public static class LowerCasingPropertyType<T>
    extends PropertyType<T> {
        public LowerCasingPropertyType(String name, String description, PropertyValueParser<T> parser, Set<String> possibleValues) {
            super(name, description, parser, possibleValues);
        }

        public LowerCasingPropertyType(String name, String description, PropertyValueParser<T> parser, String ... possibleValues) {
            super(name, description, parser, possibleValues);
        }

        @Override
        public String normalizeIfNeeded(String value) {
            return value == null ? null : value.toLowerCase(Locale.US);
        }
    }

    public static enum IndentStyleValue {
        space("Space", ' '),
        tab("Tab", '\t');

        private static final Set<String> VALUE_SET;
        private final String displayValue;
        private final char indentChar;

        public static Set<String> valueSet() {
            return VALUE_SET;
        }

        private IndentStyleValue(String displayValue, char indentChar) {
            this.displayValue = displayValue;
            this.indentChar = indentChar;
        }

        public char getIndentChar() {
            return this.indentChar;
        }

        static {
            LinkedHashSet<String> s = new LinkedHashSet<String>();
            for (IndentStyleValue v : IndentStyleValue.values()) {
                s.add(v.name());
            }
            VALUE_SET = Collections.unmodifiableSet(s);
        }
    }

    public static enum EndOfLineValue {
        cr("Carriage Return", "\r"),
        crlf("Carriage Return + Line Feed", "\r\n"),
        lf("Line Feed", "\n");

        private static final Set<String> VALUE_SET;
        private final String displayValue;
        private final String eolString;

        public static EndOfLineValue autodetect(String source) {
            if (source == null || source.isEmpty()) {
                return lf;
            }
            int lfOffset = source.indexOf(10);
            if (lfOffset == 0) {
                return lf;
            }
            if (lfOffset > 0) {
                int crOffset = source.indexOf(13);
                if (crOffset >= 0) {
                    int diff = lfOffset - crOffset;
                    if (diff == 1) {
                        return crlf;
                    }
                    if (diff > 0) {
                        return cr;
                    }
                    return lf;
                }
                return lf;
            }
            if (source.indexOf(13) >= 0) {
                return cr;
            }
            return lf;
        }

        public static EndOfLineValue ofEndOfLineString(String endOfLineString) {
            switch (endOfLineString) {
                case "\r": {
                    return cr;
                }
                case "\r\n": {
                    return crlf;
                }
                case "\n": {
                    return lf;
                }
            }
            return null;
        }

        public static Set<String> valueSet() {
            return VALUE_SET;
        }

        private EndOfLineValue(String displayValue, String eolString) {
            this.displayValue = displayValue;
            this.eolString = eolString;
        }

        public String getEndOfLineString() {
            return this.eolString;
        }

        static {
            LinkedHashSet<String> s = new LinkedHashSet<String>();
            for (EndOfLineValue v : EndOfLineValue.values()) {
                s.add(v.name());
            }
            VALUE_SET = Collections.unmodifiableSet(s);
        }
    }
}

