/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt;

import io.gitlab.arturbosch.detekt.internal.GradleCompatKt;
import io.gitlab.arturbosch.detekt.invoke.AutoCorrectArgument;
import io.gitlab.arturbosch.detekt.invoke.BaselineArgument;
import io.gitlab.arturbosch.detekt.invoke.BuildUponDefaultConfigArgument;
import io.gitlab.arturbosch.detekt.invoke.CliArgument;
import io.gitlab.arturbosch.detekt.invoke.ConfigArgument;
import io.gitlab.arturbosch.detekt.invoke.CreateBaselineArgument;
import io.gitlab.arturbosch.detekt.invoke.DebugArgument;
import io.gitlab.arturbosch.detekt.invoke.DetektInvoker;
import io.gitlab.arturbosch.detekt.invoke.DisableDefaultRuleSetArgument;
import io.gitlab.arturbosch.detekt.invoke.FailFastArgument;
import io.gitlab.arturbosch.detekt.invoke.InputArgument;
import io.gitlab.arturbosch.detekt.invoke.ParallelArgument;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\"H\u0007R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00020\t8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0016\u0010\u000e\u001a\u00020\u000f8GX\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u0013\u0010\u0014\u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0011R\u0019\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0007R\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0007R\u0019\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0007R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0007R\u0013\u0010 \u001a\u00020\u000f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0011\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/DetektCreateBaselineTask;", "Lorg/gradle/api/tasks/SourceTask;", "()V", "autoCorrect", "Lorg/gradle/api/provider/Property;", "", "getAutoCorrect", "()Lorg/gradle/api/provider/Property;", "baseline", "Lorg/gradle/api/file/RegularFileProperty;", "getBaseline", "()Lorg/gradle/api/file/RegularFileProperty;", "buildUponDefaultConfig", "getBuildUponDefaultConfig", "config", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getConfig", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "debug", "getDebug", "detektClasspath", "getDetektClasspath", "disableDefaultRuleSets", "getDisableDefaultRuleSets", "failFast", "getFailFast", "ignoreFailures", "getIgnoreFailures", "invoker", "Lio/gitlab/arturbosch/detekt/invoke/DetektInvoker;", "parallel", "getParallel", "pluginClasspath", "getPluginClasspath", "", "detekt-gradle-plugin"})
public class DetektCreateBaselineTask
extends SourceTask {
    @NotNull
    private final RegularFileProperty baseline;
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final ConfigurableFileCollection config;
    @NotNull
    private final ConfigurableFileCollection detektClasspath;
    @NotNull
    private final ConfigurableFileCollection pluginClasspath;
    @NotNull
    private final Property<Boolean> debug;
    @NotNull
    private final Property<Boolean> parallel;
    @NotNull
    private final Property<Boolean> disableDefaultRuleSets;
    @NotNull
    private final Property<Boolean> buildUponDefaultConfig;
    @NotNull
    private final Property<Boolean> failFast;
    @NotNull
    private final Property<Boolean> ignoreFailures;
    @NotNull
    private final Property<Boolean> autoCorrect;
    private final DetektInvoker invoker;

    @OutputFile
    @NotNull
    public final RegularFileProperty getBaseline() {
        return this.baseline;
    }

    @InputFiles
    @Optional
    @NotNull
    public final ConfigurableFileCollection getConfig() {
        return this.config;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getDetektClasspath() {
        return this.detektClasspath;
    }

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getPluginClasspath() {
        return this.pluginClasspath;
    }

    @Console
    @NotNull
    public final Property<Boolean> getDebug() {
        return this.debug;
    }

    @Internal
    @NotNull
    public final Property<Boolean> getParallel() {
        return this.parallel;
    }

    @Input
    @Optional
    @NotNull
    public final Property<Boolean> getDisableDefaultRuleSets() {
        return this.disableDefaultRuleSets;
    }

    @Input
    @Optional
    @NotNull
    public final Property<Boolean> getBuildUponDefaultConfig() {
        return this.buildUponDefaultConfig;
    }

    @Input
    @Optional
    @NotNull
    public final Property<Boolean> getFailFast() {
        return this.failFast;
    }

    @Input
    @Optional
    @NotNull
    public final Property<Boolean> getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Input
    @Optional
    @NotNull
    public final Property<Boolean> getAutoCorrect() {
        return this.autoCorrect;
    }

    @TaskAction
    public final void baseline() {
        Object[] objectArray = new CliArgument[10];
        objectArray[0] = CreateBaselineArgument.INSTANCE;
        objectArray[1] = new BaselineArgument((RegularFile)this.baseline.get());
        FileTree fileTree = this.getSource();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileTree, (String)"source");
        objectArray[2] = new InputArgument((FileCollection)fileTree);
        objectArray[3] = new ConfigArgument((FileCollection)this.config);
        Object object = this.debug.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"debug.getOrElse(false)");
        objectArray[4] = new DebugArgument((Boolean)object);
        Object object2 = this.parallel.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"parallel.getOrElse(false)");
        objectArray[5] = new ParallelArgument((Boolean)object2);
        Object object3 = this.buildUponDefaultConfig.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"buildUponDefaultConfig.getOrElse(false)");
        objectArray[6] = new BuildUponDefaultConfigArgument((Boolean)object3);
        Object object4 = this.failFast.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"failFast.getOrElse(false)");
        objectArray[7] = new FailFastArgument((Boolean)object4);
        Object object5 = this.autoCorrect.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"autoCorrect.getOrElse(false)");
        objectArray[8] = new AutoCorrectArgument((Boolean)object5);
        Object object6 = this.disableDefaultRuleSets.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"disableDefaultRuleSets.getOrElse(false)");
        objectArray[9] = new DisableDefaultRuleSetArgument((Boolean)object6);
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        List list = CollectionsKt.toList((Iterable)arguments);
        Object object7 = this.ignoreFailures.getOrElse((Object)false);
        Intrinsics.checkExpressionValueIsNotNull((Object)object7, (String)"ignoreFailures.getOrElse(false)");
        boolean bl = (Boolean)object7;
        FileCollection fileCollection = this.detektClasspath.plus((FileCollection)this.pluginClasspath);
        Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"detektClasspath.plus(pluginClasspath)");
        String string = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
        String string2 = string;
        FileCollection fileCollection2 = fileCollection;
        boolean bl2 = bl;
        this.invoker.invokeCli(list, fileCollection2, string2, bl2);
    }

    public DetektCreateBaselineTask() {
        this.setDescription("Creates a detekt baseline on the given --baseline path.");
        this.setGroup("verification");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        RegularFileProperty regularFileProperty = project.getObjects().fileProperty();
        Intrinsics.checkExpressionValueIsNotNull((Object)regularFileProperty, (String)"project.objects.fileProperty()");
        this.baseline = regularFileProperty;
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        this.config = GradleCompatKt.configurableFileCollection(project2);
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        this.detektClasspath = GradleCompatKt.configurableFileCollection(project3);
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        this.pluginClasspath = GradleCompatKt.configurableFileCollection(project4);
        Project project5 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project5, (String)"project");
        Property property = project5.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.debug = property;
        Project project6 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project6, (String)"project");
        Property property2 = project6.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property2, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.parallel = property2;
        Project project7 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project7, (String)"project");
        Property property3 = project7.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property3, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.disableDefaultRuleSets = property3;
        Project project8 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project8, (String)"project");
        Property property4 = project8.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property4, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.buildUponDefaultConfig = property4;
        Project project9 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project9, (String)"project");
        Property property5 = project9.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property5, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.failFast = property5;
        Project project10 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project10, (String)"project");
        Property property6 = project10.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property6, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.ignoreFailures = property6;
        Project project11 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project11, (String)"project");
        Property property7 = project11.getObjects().property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property7, (String)"project.objects.property\u2026an::class.javaObjectType)");
        this.autoCorrect = property7;
        Project project12 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project12, (String)"project");
        this.invoker = DetektInvoker.Companion.create(project12);
    }
}

