/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt;

import io.gitlab.arturbosch.detekt.internal.GradleCompatKt;
import io.gitlab.arturbosch.detekt.invoke.CliArgument;
import io.gitlab.arturbosch.detekt.invoke.ConfigArgument;
import io.gitlab.arturbosch.detekt.invoke.DetektInvoker;
import io.gitlab.arturbosch.detekt.invoke.GenerateConfigArgument;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/DetektGenerateConfigTask;", "Lorg/gradle/api/DefaultTask;", "()V", "config", "Lorg/gradle/api/file/ConfigurableFileCollection;", "kotlin.jvm.PlatformType", "configDir", "Ljava/io/File;", "detektClasspath", "getDetektClasspath", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "invoker", "Lio/gitlab/arturbosch/detekt/invoke/DetektInvoker;", "generateConfig", "", "detekt-gradle-plugin"})
public class DetektGenerateConfigTask
extends DefaultTask {
    @NotNull
    private final ConfigurableFileCollection detektClasspath;
    private final DetektInvoker invoker;
    private final File configDir;
    private final ConfigurableFileCollection config;

    @Classpath
    @NotNull
    public final ConfigurableFileCollection getDetektClasspath() {
        return this.detektClasspath;
    }

    @TaskAction
    public final void generateConfig() {
        Object[] objectArray = new CliArgument[2];
        objectArray[0] = GenerateConfigArgument.INSTANCE;
        ConfigurableFileCollection configurableFileCollection = this.config;
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"config");
        objectArray[1] = new ConfigArgument((FileCollection)configurableFileCollection);
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        try {
            ConfigurableFileCollection configurableFileCollection2 = this.config;
            Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection2, (String)"config");
            if (configurableFileCollection2.getSingleFile().exists()) {
                Logger logger = this.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("Skipping config file generation; file already exists at ");
                ConfigurableFileCollection configurableFileCollection3 = this.config;
                Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection3, (String)"config");
                logger.warn(stringBuilder.append(configurableFileCollection3.getSingleFile()).toString());
            } else {
                List list = CollectionsKt.toList((Iterable)arguments);
                FileCollection fileCollection = (FileCollection)this.detektClasspath;
                String string = this.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
                DetektInvoker.DefaultImpls.invokeCli$default(this.invoker, list, fileCollection, string, false, 8, null);
            }
        }
        catch (IllegalStateException e) {
            this.getLogger().error("Unexpected error. Please raise an issue on detekt's issue tracker.", (Throwable)e);
        }
    }

    public DetektGenerateConfigTask() {
        this.setDescription("Generate a detekt configuration file inside your project.");
        this.setGroup("verification");
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.detektClasspath = GradleCompatKt.configurableFileCollection(project);
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        this.invoker = DetektInvoker.Companion.create(project2);
        Project project3 = this.getProject();
        StringBuilder stringBuilder = new StringBuilder();
        Project project4 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"project");
        this.configDir = project3.mkdir((Object)stringBuilder.append(project4.getRootDir()).append("/config/detekt").toString());
        Project project5 = this.getProject();
        Object[] objectArray = new Object[1];
        StringBuilder stringBuilder2 = new StringBuilder();
        File file = this.configDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"configDir");
        objectArray[0] = stringBuilder2.append(file.getCanonicalPath()).append("/detekt.yml").toString();
        this.config = project5.files(objectArray);
    }
}

