/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.metrics;

import io.github.detekt.metrics.CognitiveComplexity;
import io.github.detekt.metrics.processors.ProjectCLOCProcessorKt;
import io.github.detekt.metrics.processors.ProjectComplexityProcessorKt;
import io.github.detekt.metrics.processors.ProjectLLOCProcessorKt;
import io.github.detekt.metrics.processors.ProjectLOCProcessorKt;
import io.github.detekt.metrics.processors.ProjectSLOCProcessorKt;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0015\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\bR-\u0010\f\u001a\u001e\u0012\u001a\u0012\u0018\u0012\b\u0012\u00060\u000fj\u0002`\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0015\u0010\u0015\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0016\u0010\bR\u0015\u0010\u0017\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0018\u0010\bR\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u001a\u0010\bR\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u001c\u0010\b\u00a8\u0006\u001d"}, d2={"Lio/github/detekt/metrics/ComplexityMetric;", "", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "(Lio/gitlab/arturbosch/detekt/api/Detektion;)V", "cloc", "", "getCloc", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "cognitiveComplexity", "getCognitiveComplexity", "findings", "", "", "", "Lio/gitlab/arturbosch/detekt/api/RuleSetId;", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "getFindings", "()Ljava/util/Set;", "lloc", "getLloc", "loc", "getLoc", "mcc", "getMcc", "sloc", "getSloc", "detekt-metrics"})
public final class ComplexityMetric {
    @Nullable
    private final Integer mcc;
    @Nullable
    private final Integer cognitiveComplexity;
    @Nullable
    private final Integer loc;
    @Nullable
    private final Integer sloc;
    @Nullable
    private final Integer lloc;
    @Nullable
    private final Integer cloc;
    @NotNull
    private final Set<Map.Entry<String, List<Finding>>> findings;

    public ComplexityMetric(@NotNull Detektion detektion) {
        Intrinsics.checkNotNullParameter((Object)detektion, (String)"detektion");
        this.mcc = (Integer)detektion.getData(ProjectComplexityProcessorKt.getComplexityKey());
        this.cognitiveComplexity = (Integer)detektion.getData(CognitiveComplexity.Companion.getKEY());
        this.loc = (Integer)detektion.getData(ProjectLOCProcessorKt.getLinesKey());
        this.sloc = (Integer)detektion.getData(ProjectSLOCProcessorKt.getSourceLinesKey());
        this.lloc = (Integer)detektion.getData(ProjectLLOCProcessorKt.getLogicalLinesKey());
        this.cloc = (Integer)detektion.getData(ProjectCLOCProcessorKt.getCommentLinesKey());
        this.findings = detektion.getFindings().entrySet();
    }

    @Nullable
    public final Integer getMcc() {
        return this.mcc;
    }

    @Nullable
    public final Integer getCognitiveComplexity() {
        return this.cognitiveComplexity;
    }

    @Nullable
    public final Integer getLoc() {
        return this.loc;
    }

    @Nullable
    public final Integer getSloc() {
        return this.sloc;
    }

    @Nullable
    public final Integer getLloc() {
        return this.lloc;
    }

    @Nullable
    public final Integer getCloc() {
        return this.cloc;
    }

    @NotNull
    public final Set<Map.Entry<String, List<Finding>>> getFindings() {
        return this.findings;
    }
}

