/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.metrics.processors.util;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\rR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/github/detekt/metrics/processors/util/LLOC;", "", "()V", "comments", "", "", "[Ljava/lang/String;", "escapes", "analyze", "", "lines", "", "isCommentMode", "", "isFullMode", "LLOCCounter", "detekt-metrics"})
public final class LLOC {
    @NotNull
    public static final LLOC INSTANCE = new LLOC();
    @NotNull
    private static final String[] comments;
    @NotNull
    private static final String[] escapes;

    private LLOC() {
    }

    public final int analyze(@NotNull List<String> lines, boolean isCommentMode, boolean isFullMode) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        return new LLOCCounter(lines, isCommentMode, isFullMode).run();
    }

    public static /* synthetic */ int analyze$default(LLOC lLOC, List list, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        return lLOC.analyze(list, bl, bl2);
    }

    static {
        String[] stringArray = new String[]{"//", "/*", "*/", "*"};
        comments = stringArray;
        stringArray = new String[]{"import", "package"};
        escapes = stringArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J#\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00042\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\nR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/github/detekt/metrics/processors/util/LLOC$LLOCCounter;", "", "lines", "", "", "isCommentMode", "", "isFullMode", "(Ljava/util/List;ZZ)V", "closedBrackets", "", "counter", "escape", "openedBrackets", "countOrEscapeAdditionalStatements", "", "trimmed", "countOrEscapeComment", "countStatementsAndDeclarations", "frequency", "source", "part", "isEscaped", "rules", "", "(Ljava/lang/String;[Ljava/lang/String;)Z", "run", "detekt-metrics"})
    @SourceDebugExtension(value={"SMAP\nLLOC.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLOC.kt\nio/github/detekt/metrics/processors/util/LLOC$LLOCCounter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,101:1\n12474#2,2:102\n*S KotlinDebug\n*F\n+ 1 LLOC.kt\nio/github/detekt/metrics/processors/util/LLOC$LLOCCounter\n*L\n81#1:102,2\n*E\n"})
    private static final class LLOCCounter {
        @NotNull
        private final List<String> lines;
        private final boolean isCommentMode;
        private final boolean isFullMode;
        private int counter;
        private int openedBrackets;
        private int closedBrackets;
        private boolean escape;

        public LLOCCounter(@NotNull List<String> lines, boolean isCommentMode, boolean isFullMode) {
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            this.lines = lines;
            this.isCommentMode = isCommentMode;
            this.isFullMode = isFullMode;
        }

        public /* synthetic */ LLOCCounter(List list, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(list, bl, bl2);
        }

        public final int run() {
            for (String line : this.lines) {
                String trimmed = ((Object)StringsKt.trim((CharSequence)line)).toString();
                if (((CharSequence)trimmed).length() == 0) continue;
                this.countOrEscapeComment(trimmed);
                if (this.escape) continue;
                this.countOrEscapeAdditionalStatements(trimmed);
                if (this.escape) continue;
                this.countStatementsAndDeclarations(trimmed);
            }
            return this.counter + (this.openedBrackets - this.closedBrackets == 0 ? this.openedBrackets : -1);
        }

        private final void countStatementsAndDeclarations(String trimmed) {
            int n;
            if (StringsKt.contains$default((CharSequence)trimmed, (CharSequence)";", (boolean)false, (int)2, null)) {
                n = this.counter;
                this.counter = n + 1;
            }
            if (StringsKt.contains$default((CharSequence)trimmed, (CharSequence)"{", (boolean)false, (int)2, null)) {
                this.openedBrackets += this.frequency(trimmed, "{");
            } else if (trimmed.length() != 1) {
                n = this.counter;
                this.counter = n + 1;
            }
            if (StringsKt.contains$default((CharSequence)trimmed, (CharSequence)"}", (boolean)false, (int)2, null)) {
                this.closedBrackets += this.frequency(trimmed, "}");
            }
        }

        private final void countOrEscapeAdditionalStatements(String trimmed) {
            this.escape = this.isEscaped(trimmed, escapes);
            if (this.escape && this.isFullMode) {
                int n = this.counter;
                this.counter = n + 1;
            }
        }

        private final void countOrEscapeComment(String trimmed) {
            this.escape = this.isEscaped(trimmed, comments);
            if (this.isCommentMode && this.escape) {
                int n = this.counter;
                this.counter = n + 1;
            }
        }

        private final boolean isEscaped(String trimmed, String[] rules) {
            boolean bl;
            block1: {
                String[] $this$any$iv = rules;
                boolean $i$f$any = false;
                int n = $this$any$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$any$iv[i];
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)trimmed, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private final int frequency(String source, String part) {
            if (((CharSequence)source).length() == 0 || ((CharSequence)part).length() == 0) {
                return 0;
            }
            int count = 0;
            int pos = StringsKt.indexOf$default((CharSequence)source, (String)part, (int)0, (boolean)false, (int)4, null);
            while (pos != -1) {
                pos += part.length();
                ++count;
                pos = StringsKt.indexOf$default((CharSequence)source, (String)part, (int)pos, (boolean)false, (int)4, null);
            }
            return count;
        }
    }
}

