/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.metrics;

import io.github.detekt.metrics.CognitiveComplexity;
import io.github.detekt.metrics.processors.ProjectCLOCProcessorKt;
import io.github.detekt.metrics.processors.ProjectComplexityProcessorKt;
import io.github.detekt.metrics.processors.ProjectLLOCProcessorKt;
import io.github.detekt.metrics.processors.ProjectLOCProcessorKt;
import io.github.detekt.metrics.processors.ProjectSLOCProcessorKt;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\"\n\u0002\u0010&\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0015\u0010\u000b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\f\u0010\tR\u0015\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000e\u0010\tR\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0010\u0010\tR\u0015\u0010\u0011\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0012\u0010\tR\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u0014\u0010\tR)\u0010\u0015\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lio/github/detekt/metrics/ComplexityMetric;", "", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Detektion;)V", "mcc", "", "getMcc", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "cognitiveComplexity", "getCognitiveComplexity", "loc", "getLoc", "sloc", "getSloc", "lloc", "getLloc", "cloc", "getCloc", "findings", "", "", "", "", "Lio/gitlab/arturbosch/detekt/api/Finding;", "getFindings", "()Ljava/util/Set;", "detekt-metrics"})
public final class ComplexityMetric {
    @Nullable
    private final Integer mcc;
    @Nullable
    private final Integer cognitiveComplexity;
    @Nullable
    private final Integer loc;
    @Nullable
    private final Integer sloc;
    @Nullable
    private final Integer lloc;
    @Nullable
    private final Integer cloc;
    @NotNull
    private final Set<Map.Entry<String, List<Finding>>> findings;

    public ComplexityMetric(@NotNull Detektion detektion) {
        Intrinsics.checkNotNullParameter((Object)detektion, (String)"detektion");
        this.mcc = (Integer)detektion.getData(ProjectComplexityProcessorKt.getComplexityKey());
        this.cognitiveComplexity = (Integer)detektion.getData(CognitiveComplexity.Companion.getKEY());
        this.loc = (Integer)detektion.getData(ProjectLOCProcessorKt.getLinesKey());
        this.sloc = (Integer)detektion.getData(ProjectSLOCProcessorKt.getSourceLinesKey());
        this.lloc = (Integer)detektion.getData(ProjectLLOCProcessorKt.getLogicalLinesKey());
        this.cloc = (Integer)detektion.getData(ProjectCLOCProcessorKt.getCommentLinesKey());
        this.findings = detektion.getFindings().entrySet();
    }

    @Nullable
    public final Integer getMcc() {
        return this.mcc;
    }

    @Nullable
    public final Integer getCognitiveComplexity() {
        return this.cognitiveComplexity;
    }

    @Nullable
    public final Integer getLoc() {
        return this.loc;
    }

    @Nullable
    public final Integer getSloc() {
        return this.sloc;
    }

    @Nullable
    public final Integer getLloc() {
        return this.lloc;
    }

    @Nullable
    public final Integer getCloc() {
        return this.cloc;
    }

    @NotNull
    public final Set<Map.Entry<String, List<Finding>>> getFindings() {
        return this.findings;
    }
}

