/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.parser;

import io.github.detekt.parser.KotlinEnvironmentUtilsKt;
import io.github.detekt.parser.KtCompilerKt;
import io.github.detekt.psi.KeysKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtilRt;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJ \u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/github/detekt/parser/KtCompiler;", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "psiFileFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "getPsiFileFactory", "()Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "compile", "Lorg/jetbrains/kotlin/psi/KtFile;", "basePath", "Ljava/nio/file/Path;", "path", "createKtFile", "content", "", "detekt-parser"})
public class KtCompiler {
    @NotNull
    private final KotlinCoreEnvironment environment;
    @NotNull
    private final KtPsiFactory psiFileFactory;

    public KtCompiler(@NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.environment = environment;
        this.psiFileFactory = new KtPsiFactory(this.environment.getProject(), false);
    }

    public /* synthetic */ KtCompiler(KotlinCoreEnvironment kotlinCoreEnvironment, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            kotlinCoreEnvironment = KotlinEnvironmentUtilsKt.createKotlinCoreEnvironment$default(null, null, 3, null);
        }
        this(kotlinCoreEnvironment);
    }

    @NotNull
    protected final KotlinCoreEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    protected final KtPsiFactory getPsiFileFactory() {
        return this.psiFileFactory;
    }

    @NotNull
    public final KtFile compile(@Nullable Path basePath, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            boolean bl = false;
            String string = "Given sub path (" + path + ") should be a regular file!";
            throw new IllegalArgumentException(string.toString());
        }
        File file = path.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"path.toFile()");
        String content = FilesKt.readText$default((File)file, null, (int)1, null);
        return this.createKtFile(content, basePath, path);
    }

    @NotNull
    public final KtFile createKtFile(@NotNull String content, @Nullable Path basePath, @NotNull Path path) {
        KtFile ktFile;
        block1: {
            Path path2;
            KtFile psiFile;
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                boolean $i$a$-require-KtCompiler$createKtFile$22 = false;
                String $i$a$-require-KtCompiler$createKtFile$22 = "Given sub path (" + path + ") should be a regular file!";
                throw new IllegalArgumentException($i$a$-require-KtCompiler$createKtFile$22.toString());
            }
            Path normalizedAbsolutePath = path.toAbsolutePath().normalize();
            String lineSeparator = KtCompilerKt.determineLineSeparator(content);
            String string = ((Object)normalizedAbsolutePath).toString();
            String string2 = StringUtilRt.convertLineSeparators((String)content);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertLineSeparators(content)");
            KtFile $this$createKtFile_u24lambda_u2d3 = ktFile = (psiFile = this.psiFileFactory.createPhysicalFile(string, string2));
            boolean bl = false;
            $this$createKtFile_u24lambda_u2d3.putUserData(KeysKt.getLINE_SEPARATOR(), (Object)lineSeparator);
            Path path3 = basePath;
            Path normalizedBasePath = path3 != null && (path3 = path3.toAbsolutePath()) != null ? path3.normalize() : null;
            Path path4 = normalizedBasePath;
            if (path4 == null || (path4 = (path2 = path4.relativize(normalizedAbsolutePath))) == null) break block1;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"relativize(normalizedAbsolutePath)");
            Path relativePath = path2;
            boolean bl2 = false;
            $this$createKtFile_u24lambda_u2d3.putUserData(KeysKt.getBASE_PATH(), (Object)((Object)normalizedBasePath.toAbsolutePath()).toString());
            $this$createKtFile_u24lambda_u2d3.putUserData(KeysKt.getRELATIVE_PATH(), (Object)((Object)relativePath).toString());
        }
        return ktFile;
    }

    public KtCompiler() {
        this(null, 1, null);
    }
}

