@file:Suppress("MaxLineLength")

package io.github.detekt.psi.internal

/*
 The entries of this map was generate with this script:

#!/usr/bin/env bash

print_classes() {
  packages=(kotlin kotlin.annotation kotlin.collections kotlin.comparisons kotlin.io kotlin.ranges kotlin.sequences kotlin.text)

  for package in "${packages[@]}"; do
    curl -s "https://kotlinlang.org/api/latest/jvm/stdlib/$package/" | gsed -n -E "s|<h4><a href=\".*\">([A-Z].*)</a></h4>|\"\1\" to \"$package.\1\",|p"
  done
}

print_classes | sort -u | gsed '/^"[A-Z_]*"/d'

And the list of packages that should be considered was extracted from the kotlin documentation:
https://kotlinlang.org/docs/packages.html#default-imports
 */
internal val defaultImportClasses = mapOf(
    "AbstractCollection" to "kotlin.collections.AbstractCollection",
    "AbstractIterator" to "kotlin.collections.AbstractIterator",
    "AbstractList" to "kotlin.collections.AbstractList",
    "AbstractMap" to "kotlin.collections.AbstractMap",
    "AbstractMutableCollection" to "kotlin.collections.AbstractMutableCollection",
    "AbstractMutableList" to "kotlin.collections.AbstractMutableList",
    "AbstractMutableMap" to "kotlin.collections.AbstractMutableMap",
    "AbstractMutableSet" to "kotlin.collections.AbstractMutableSet",
    "AbstractSet" to "kotlin.collections.AbstractSet",
    "AccessDeniedException" to "kotlin.io.AccessDeniedException",
    "Annotation" to "kotlin.Annotation",
    "AnnotationRetention" to "kotlin.annotation.AnnotationRetention",
    "AnnotationTarget" to "kotlin.annotation.AnnotationTarget",
    "Any" to "kotlin.Any",
    "Appendable" to "kotlin.text.Appendable",
    "ArithmeticException" to "kotlin.ArithmeticException",
    "Array" to "kotlin.Array",
    "ArrayDeque" to "kotlin.collections.ArrayDeque",
    "ArrayIndexOutOfBoundsException" to "kotlin.ArrayIndexOutOfBoundsException",
    "ArrayList" to "kotlin.collections.ArrayList",
    "AssertionError" to "kotlin.AssertionError",
    "Boolean" to "kotlin.Boolean",
    "BooleanArray" to "kotlin.BooleanArray",
    "BooleanIterator" to "kotlin.collections.BooleanIterator",
    "BuilderInference" to "kotlin.BuilderInference",
    "Byte" to "kotlin.Byte",
    "ByteArray" to "kotlin.ByteArray",
    "ByteIterator" to "kotlin.collections.ByteIterator",
    "ClassCastException" to "kotlin.ClassCastException",
    "ClosedFloatingPointRange" to "kotlin.ranges.ClosedFloatingPointRange",
    "ClosedRange" to "kotlin.ranges.ClosedRange",
    "Collection" to "kotlin.collections.Collection",
    "Comparable" to "kotlin.Comparable",
    "Comparator" to "kotlin.Comparator",
    "ConcurrentModificationException" to "kotlin.ConcurrentModificationException",
    "Char" to "kotlin.Char",
    "CharArray" to "kotlin.CharArray",
    "CharCategory" to "kotlin.text.CharCategory",
    "CharDirectionality" to "kotlin.text.CharDirectionality",
    "CharIterator" to "kotlin.collections.CharIterator",
    "CharProgression" to "kotlin.ranges.CharProgression",
    "CharRange" to "kotlin.ranges.CharRange",
    "CharSequence" to "kotlin.CharSequence",
    "CharacterCodingException" to "kotlin.text.CharacterCodingException",
    "Charsets" to "kotlin.text.Charsets",
    "DeepRecursiveFunction" to "kotlin.DeepRecursiveFunction",
    "DeepRecursiveScope" to "kotlin.DeepRecursiveScope",
    "Deprecated" to "kotlin.Deprecated",
    "DeprecatedSinceKotlin" to "kotlin.DeprecatedSinceKotlin",
    "DeprecationLevel" to "kotlin.DeprecationLevel",
    "Double" to "kotlin.Double",
    "DoubleArray" to "kotlin.DoubleArray",
    "DoubleIterator" to "kotlin.collections.DoubleIterator",
    "DslMarker" to "kotlin.DslMarker",
    "Enum" to "kotlin.Enum",
    "Error" to "kotlin.Error",
    "Exception" to "kotlin.Exception",
    "Experimental" to "kotlin.Experimental",
    "ExperimentalMultiplatform" to "kotlin.ExperimentalMultiplatform",
    "ExperimentalStdlibApi" to "kotlin.ExperimentalStdlibApi",
    "ExperimentalUnsignedTypes" to "kotlin.ExperimentalUnsignedTypes",
    "ExtensionFunctionType" to "kotlin.ExtensionFunctionType",
    "FileAlreadyExistsException" to "kotlin.io.FileAlreadyExistsException",
    "FileSystemException" to "kotlin.io.FileSystemException",
    "FileTreeWalk" to "kotlin.io.FileTreeWalk",
    "FileWalkDirection" to "kotlin.io.FileWalkDirection",
    "Float" to "kotlin.Float",
    "FloatArray" to "kotlin.FloatArray",
    "FloatIterator" to "kotlin.collections.FloatIterator",
    "Function" to "kotlin.Function",
    "Grouping" to "kotlin.collections.Grouping",
    "HashMap" to "kotlin.collections.HashMap",
    "HashSet" to "kotlin.collections.HashSet",
    "IllegalArgumentException" to "kotlin.IllegalArgumentException",
    "IllegalStateException" to "kotlin.IllegalStateException",
    "IndexOutOfBoundsException" to "kotlin.IndexOutOfBoundsException",
    "IndexedValue" to "kotlin.collections.IndexedValue",
    "Int" to "kotlin.Int",
    "IntArray" to "kotlin.IntArray",
    "IntIterator" to "kotlin.collections.IntIterator",
    "IntProgression" to "kotlin.ranges.IntProgression",
    "IntRange" to "kotlin.ranges.IntRange",
    "Iterable" to "kotlin.collections.Iterable",
    "Iterator" to "kotlin.collections.Iterator",
    "KotlinNullPointerException" to "kotlin.KotlinNullPointerException",
    "KotlinVersion" to "kotlin.KotlinVersion",
    "Lazy" to "kotlin.Lazy",
    "LazyThreadSafetyMode" to "kotlin.LazyThreadSafetyMode",
    "LinkedHashMap" to "kotlin.collections.LinkedHashMap",
    "LinkedHashSet" to "kotlin.collections.LinkedHashSet",
    "List" to "kotlin.collections.List",
    "ListIterator" to "kotlin.collections.ListIterator",
    "Long" to "kotlin.Long",
    "LongArray" to "kotlin.LongArray",
    "LongIterator" to "kotlin.collections.LongIterator",
    "LongProgression" to "kotlin.ranges.LongProgression",
    "LongRange" to "kotlin.ranges.LongRange",
    "Map" to "kotlin.collections.Map",
    "MatchGroup" to "kotlin.text.MatchGroup",
    "MatchGroupCollection" to "kotlin.text.MatchGroupCollection",
    "MatchNamedGroupCollection" to "kotlin.text.MatchNamedGroupCollection",
    "MatchResult" to "kotlin.text.MatchResult",
    "Metadata" to "kotlin.Metadata",
    "MustBeDocumented" to "kotlin.annotation.MustBeDocumented",
    "MutableCollection" to "kotlin.collections.MutableCollection",
    "MutableIterable" to "kotlin.collections.MutableIterable",
    "MutableIterator" to "kotlin.collections.MutableIterator",
    "MutableList" to "kotlin.collections.MutableList",
    "MutableListIterator" to "kotlin.collections.MutableListIterator",
    "MutableMap" to "kotlin.collections.MutableMap",
    "MutableSet" to "kotlin.collections.MutableSet",
    "NoSuchElementException" to "kotlin.NoSuchElementException",
    "NoSuchFileException" to "kotlin.io.NoSuchFileException",
    "NoWhenBranchMatchedException" to "kotlin.NoWhenBranchMatchedException",
    "NotImplementedError" to "kotlin.NotImplementedError",
    "Nothing" to "kotlin.Nothing",
    "NullPointerException" to "kotlin.NullPointerException",
    "Number" to "kotlin.Number",
    "NumberFormatException" to "kotlin.NumberFormatException",
    "OnErrorAction" to "kotlin.io.OnErrorAction",
    "OptIn" to "kotlin.OptIn",
    "OptionalExpectation" to "kotlin.OptionalExpectation",
    "OutOfMemoryError" to "kotlin.OutOfMemoryError",
    "OverloadResolutionByLambdaReturnType" to "kotlin.OverloadResolutionByLambdaReturnType",
    "Pair" to "kotlin.Pair",
    "ParameterName" to "kotlin.ParameterName",
    "PublishedApi" to "kotlin.PublishedApi",
    "RandomAccess" to "kotlin.collections.RandomAccess",
    "Regex" to "kotlin.text.Regex",
    "RegexOption" to "kotlin.text.RegexOption",
    "Repeatable" to "kotlin.annotation.Repeatable",
    "ReplaceWith" to "kotlin.ReplaceWith",
    "RequiresOptIn" to "kotlin.RequiresOptIn",
    "Result" to "kotlin.Result",
    "Retention" to "kotlin.annotation.Retention",
    "RuntimeException" to "kotlin.RuntimeException",
    "Sequence" to "kotlin.sequences.Sequence",
    "SequenceBuilder" to "kotlin.sequences.SequenceBuilder",
    "SequenceScope" to "kotlin.sequences.SequenceScope",
    "Set" to "kotlin.collections.Set",
    "Short" to "kotlin.Short",
    "ShortArray" to "kotlin.ShortArray",
    "ShortIterator" to "kotlin.collections.ShortIterator",
    "SinceKotlin" to "kotlin.SinceKotlin",
    "String" to "kotlin.String",
    "String" to "kotlin.text.String",
    "StringBuilder" to "kotlin.text.StringBuilder",
    "Suppress" to "kotlin.Suppress",
    "Target" to "kotlin.annotation.Target",
    "Throwable" to "kotlin.Throwable",
    "Throws" to "kotlin.Throws",
    "Triple" to "kotlin.Triple",
    "TypeCastException" to "kotlin.TypeCastException",
    "Typography" to "kotlin.text.Typography",
    "UByte" to "kotlin.UByte",
    "UByteArray" to "kotlin.UByteArray",
    "UByteIterator" to "kotlin.collections.UByteIterator",
    "UInt" to "kotlin.UInt",
    "UIntArray" to "kotlin.UIntArray",
    "UIntIterator" to "kotlin.collections.UIntIterator",
    "UIntProgression" to "kotlin.ranges.UIntProgression",
    "UIntRange" to "kotlin.ranges.UIntRange",
    "ULong" to "kotlin.ULong",
    "ULongArray" to "kotlin.ULongArray",
    "ULongIterator" to "kotlin.collections.ULongIterator",
    "ULongProgression" to "kotlin.ranges.ULongProgression",
    "ULongRange" to "kotlin.ranges.ULongRange",
    "UShort" to "kotlin.UShort",
    "UShortArray" to "kotlin.UShortArray",
    "UShortIterator" to "kotlin.collections.UShortIterator",
    "UninitializedPropertyAccessException" to "kotlin.UninitializedPropertyAccessException",
    "Unit" to "kotlin.Unit",
    "UnsafeVariance" to "kotlin.UnsafeVariance",
    "UnsupportedOperationException" to "kotlin.UnsupportedOperationException",
    "UseExperimental" to "kotlin.UseExperimental",
)
