/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.report.md;

import io.github.detekt.metrics.ComplexityReportGenerator;
import io.github.detekt.report.md.MdOutputReportKt;
import io.github.detekt.utils.MarkdownContent;
import io.github.detekt.utils.MarkdownKt;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.OutputReport;
import io.gitlab.arturbosch.detekt.api.internal.VersionsKt;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0002J\b\u0010\u000f\u001a\u00020\u0004H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lio/github/detekt/report/md/MdOutputReport;", "Lio/gitlab/arturbosch/detekt/api/OutputReport;", "()V", "ending", "", "getEnding", "()Ljava/lang/String;", "name", "getName", "getComplexityMetrics", "", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "render", "renderDate", "renderVersion", "detekt-report-md"})
@SourceDebugExtension(value={"SMAP\nMdOutputReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdOutputReport.kt\nio/github/detekt/report/md/MdOutputReport\n+ 2 Markdown.kt\nio/github/detekt/utils/MarkdownKt\n*L\n1#1,175:1\n20#2,2:176\n32#2:178\n33#2:179\n33#2:180\n27#2:181\n22#2:182\n*S KotlinDebug\n*F\n+ 1 MdOutputReport.kt\nio/github/detekt/report/md/MdOutputReport\n*L\n41#1:176,2\n42#1:178\n44#1:179\n47#1:180\n53#1:181\n41#1:182\n*E\n"})
public final class MdOutputReport
extends OutputReport {
    @NotNull
    private final String ending;
    @NotNull
    private final String name;

    public MdOutputReport() {
        this.ending = "md";
        this.name = "Markdown report";
    }

    @NotNull
    public String getEnding() {
        return this.ending;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String render(@NotNull Detektion detektion) {
        Intrinsics.checkNotNullParameter((Object)detektion, (String)"detektion");
        boolean $i$f$markdown = false;
        MarkdownContent markdown$iv = new MarkdownContent(null, 1, null);
        boolean bl = false;
        MarkdownContent $this$render_u24lambda_u244 = markdown$iv;
        boolean bl2 = false;
        MarkdownContent $this$h1$iv = $this$render_u24lambda_u244;
        boolean $i$f$h1 = false;
        StringBuilder stringBuilder = new StringBuilder().append("# ");
        MarkdownContent markdownContent = $this$h1$iv;
        boolean bl3 = false;
        String string = "detekt";
        markdownContent.append(stringBuilder.append(string).append('\n').toString());
        MarkdownContent $this$h2$iv = $this$render_u24lambda_u244;
        boolean $i$f$h2 = false;
        stringBuilder = new StringBuilder().append("## ");
        markdownContent = $this$h2$iv;
        boolean bl4 = false;
        string = "Metrics";
        markdownContent.append(stringBuilder.append(string).append('\n').toString());
        MdOutputReportKt.access$renderMetrics($this$render_u24lambda_u244, detektion.getMetrics());
        $this$h2$iv = $this$render_u24lambda_u244;
        $i$f$h2 = false;
        stringBuilder = new StringBuilder().append("## ");
        markdownContent = $this$h2$iv;
        boolean bl5 = false;
        string = "Complexity Report";
        markdownContent.append(stringBuilder.append(string).append('\n').toString());
        MdOutputReportKt.access$renderComplexity($this$render_u24lambda_u244, this.getComplexityMetrics(detektion));
        MdOutputReportKt.access$renderFindings($this$render_u24lambda_u244, detektion.getFindings());
        MarkdownKt.emptyLine((MarkdownContent)$this$render_u24lambda_u244);
        MarkdownContent $this$paragraph$iv = $this$render_u24lambda_u244;
        boolean $i$f$paragraph = false;
        stringBuilder = new StringBuilder();
        markdownContent = $this$paragraph$iv;
        boolean bl6 = false;
        String detektLink = MdOutputReportKt.link($this$render_u24lambda_u244, "detekt version " + this.renderVersion(), "https://detekt.dev/");
        string = "generated with " + detektLink + " on " + this.renderDate();
        markdownContent.append(stringBuilder.append(string).append('\n').toString());
        return markdown$iv.getContent();
    }

    private final String renderVersion() {
        return VersionsKt.whichDetekt();
    }

    private final String renderDate() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return OffsetDateTime.now(ZoneOffset.UTC).format(formatter) + " UTC";
    }

    private final List<String> getComplexityMetrics(Detektion detektion) {
        List list = ComplexityReportGenerator.Factory.create(detektion).generate();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

