/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.report.xml;

import io.github.detekt.report.xml.Xml10EscapeSymbolsInitializer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/github/detekt/report/xml/XmlEscape;", "", "()V", "REFERENCE_HEXA_PREFIX", "", "REFERENCE_SUFFIX", "", "escapeXml", "", "text", "detekt-report-xml"})
public final class XmlEscape {
    @NotNull
    public static final XmlEscape INSTANCE = new XmlEscape();
    @NotNull
    private static final char[] REFERENCE_HEXA_PREFIX;
    private static final char REFERENCE_SUFFIX = ';';

    private XmlEscape() {
    }

    @NotNull
    public final String escapeXml(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Xml10EscapeSymbolsInitializer.XmlEscapeSymbols symbols = Xml10EscapeSymbolsInitializer.INSTANCE.initializeXml10();
        byte level = 2;
        StringBuilder strBuilder = null;
        int offset = 0;
        int max = text.length();
        int readOffset = offset;
        int i = offset;
        while (i < max) {
            int codepoint = Character.codePointAt(text, i);
            boolean codepointValid = symbols.getCODEPOINT_VALIDATOR().isValid(codepoint);
            if (codepoint <= 159 && level < symbols.getESCAPE_LEVELS()[codepoint] && codepointValid) {
                ++i;
                continue;
            }
            if (codepoint > 159 && level < symbols.getESCAPE_LEVELS()[160] && codepointValid) {
                if (Character.charCount(codepoint) > 1) {
                    ++i;
                }
                ++i;
                continue;
            }
            if (strBuilder == null) {
                strBuilder = new StringBuilder(max + 20);
            }
            if (i - readOffset > 0) {
                strBuilder.append(text, readOffset, i);
            }
            if (Character.charCount(codepoint) > 1) {
                ++i;
            }
            readOffset = i + 1;
            if (!codepointValid) {
                ++i;
                continue;
            }
            int codepointIndex = ArraysKt.binarySearch$default((int[])symbols.getSORTED_CODEPOINTS(), (int)codepoint, (int)0, (int)0, (int)6, null);
            if (codepointIndex >= 0) {
                strBuilder.append(symbols.getSORTED_CERS_BY_CODEPOINT()[codepointIndex]);
                ++i;
                continue;
            }
            strBuilder.append(REFERENCE_HEXA_PREFIX);
            strBuilder.append(Integer.toHexString(codepoint));
            strBuilder.append(';');
            ++i;
        }
        if (strBuilder == null) {
            return text;
        }
        if (max - readOffset > 0) {
            strBuilder.append(text, readOffset, max);
        }
        String string = strBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        char[] cArray = "&#x".toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        REFERENCE_HEXA_PREFIX = cArray;
    }
}

