/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.report.xml;

import io.github.detekt.report.xml.XmlEscape;
import io.gitlab.arturbosch.detekt.api.Detektion;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.OutputReport;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0018\u0010\n\u001a\u00020\u0005*\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lio/github/detekt/report/xml/XmlOutputReport;", "Lio/gitlab/arturbosch/detekt/api/OutputReport;", "<init>", "()V", "ending", "", "getEnding", "()Ljava/lang/String;", "name", "getName", "severityLabel", "Lio/gitlab/arturbosch/detekt/api/Finding;", "getSeverityLabel", "(Lio/gitlab/arturbosch/detekt/api/Finding;)Ljava/lang/String;", "render", "detektion", "Lio/gitlab/arturbosch/detekt/api/Detektion;", "toXmlString", "", "detekt-report-xml"})
@SourceDebugExtension(value={"SMAP\nXmlOutputReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlOutputReport.kt\nio/github/detekt/report/xml/XmlOutputReport\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,50:1\n77#2:51\n97#2,5:52\n216#2:71\n217#2:74\n1485#3:57\n1510#3,3:58\n1513#3,3:68\n1863#3,2:72\n381#4,7:61\n*S KotlinDebug\n*F\n+ 1 XmlOutputReport.kt\nio/github/detekt/report/xml/XmlOutputReport\n*L\n23#1:51\n23#1:52,5\n30#1:71\n30#1:74\n29#1:57\n29#1:58,3\n29#1:68,3\n32#1:72,2\n29#1:61,7\n*E\n"})
public final class XmlOutputReport
extends OutputReport {
    @NotNull
    private final String ending;
    @NotNull
    private final String name;

    public XmlOutputReport() {
        this.ending = "xml";
        this.name = "Checkstyle XML report";
    }

    @NotNull
    public String getEnding() {
        return this.ending;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    private final String getSeverityLabel(Finding $this$severityLabel) {
        String string = $this$severityLabel.getSeverity().name();
        Locale locale = Locale.US;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String render(@NotNull Detektion detektion) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)detektion, (String)"detektion");
        Map $this$flatMap$iv = detektion.getFindings();
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry it = entry = iterator.next();
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)it.getValue();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List smells = (List)destination$iv$iv;
        ArrayList lines = new ArrayList();
        ((Collection)lines).add("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        ((Collection)lines).add("<checkstyle version=\"4.3\">");
        Object $this$groupBy$iv = smells;
        boolean $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Finding it = (Finding)element$iv$iv;
            boolean bl = false;
            Path path = it.getLocation().getFilePath().getRelativePath();
            if (path == null) {
                path = it.getLocation().getFilePath().getAbsolutePath();
            }
            Path key$iv$iv = path;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator2.next();
            boolean bl = false;
            Path filePath = (Path)entry.getKey();
            List findings = (List)entry.getValue();
            ((Collection)lines).add("<file name=\"" + this.toXmlString(PathsKt.getInvariantSeparatorsPathString((Path)filePath)) + "\">");
            Iterable $this$forEach$iv2 = findings;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Finding it = (Finding)element$iv2;
                boolean bl3 = false;
                Collection collection = lines;
                Object object = new String[]{"\t<error line=\"" + this.toXmlString(it.getLocation().getSource().getLine()) + '\"', "column=\"" + this.toXmlString(it.getLocation().getSource().getColumn()) + '\"', "severity=\"" + this.toXmlString(this.getSeverityLabel(it)) + '\"', "message=\"" + this.toXmlString(it.messageOrDescription()) + '\"', "source=\"detekt." + this.toXmlString(it.getId()) + "\" />"};
                object = ArraysKt.joinToString$default((Object[])object, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                collection.add(object);
            }
            ((Collection)lines).add("</file>");
        }
        ((Collection)lines).add("</checkstyle>");
        return CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    private final String toXmlString(Object $this$toXmlString) {
        return XmlEscape.INSTANCE.escapeXml(((Object)StringsKt.trim((CharSequence)$this$toXmlString.toString())).toString());
    }
}

