/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.complexity.StringLiteralDuplication;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0002%&B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\u00020\u00128BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\f\u0012\u0004\b\u0013\u0010\b\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u00020\u001c8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\f\u0012\u0004\b\u001d\u0010\b\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006'"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeStringsWithLessThan5Characters", "", "getExcludeStringsWithLessThan5Characters$annotations", "()V", "getExcludeStringsWithLessThan5Characters", "()Z", "excludeStringsWithLessThan5Characters$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreAnnotation", "getIgnoreAnnotation$annotations", "getIgnoreAnnotation", "ignoreAnnotation$delegate", "ignoreStringsRegex", "Lkotlin/text/Regex;", "getIgnoreStringsRegex$annotations", "getIgnoreStringsRegex", "()Lkotlin/text/Regex;", "ignoreStringsRegex$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "getThreshold", "()I", "threshold$delegate", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "StringLiteralVisitor", "detekt-rules-complexity"})
public final class StringLiteralDuplication
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreAnnotation$delegate;
    @NotNull
    private final ReadOnlyProperty excludeStringsWithLessThan5Characters$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreStringsRegex$delegate;
    private static final int STRING_EXCLUSION_LENGTH = 5;

    public StringLiteralDuplication(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Multiple occurrences of the same string literal within a single file detected. Prefer extracting the string literal into a property or constant.", Debt.Companion.getFIVE_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)3);
        this.ignoreAnnotation$delegate = ConfigPropertyKt.config((Object)true);
        this.excludeStringsWithLessThan5Characters$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreStringsRegex$delegate = ConfigPropertyKt.config((Object)"$^", (Function1)ignoreStringsRegex.2.INSTANCE);
    }

    public /* synthetic */ StringLiteralDuplication(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="amount of duplications to trigger rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final boolean getIgnoreAnnotation() {
        return (Boolean)this.ignoreAnnotation$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="if values in Annotations should be ignored")
    private static /* synthetic */ void getIgnoreAnnotation$annotations() {
    }

    private final boolean getExcludeStringsWithLessThan5Characters() {
        return (Boolean)this.excludeStringsWithLessThan5Characters$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="if short strings should be excluded")
    private static /* synthetic */ void getExcludeStringsWithLessThan5Characters$annotations() {
    }

    private final Regex getIgnoreStringsRegex() {
        return (Regex)this.ignoreStringsRegex$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="RegEx of Strings that should be ignored")
    private static /* synthetic */ void getIgnoreStringsRegex$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        StringLiteralVisitor visitor = new StringLiteralVisitor();
        file.accept((PsiElementVisitor)visitor);
        String type = "SIZE: ";
        for (Map.Entry<String, Integer> entry : visitor.getLiteralsOverThreshold().entrySet()) {
            String name = entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            Pair<Entity, List<Entity>> pair = visitor.entitiesForLiteral(name);
            Entity main = (Entity)pair.component1();
            List references = (List)pair.component2();
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), main, new Metric(type + name, value, this.getThreshold(), false, 0, 24, null), this.getIssue().getDescription(), references));
        }
    }

    public StringLiteralDuplication() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StringLiteralDuplication.class, "threshold", "getThreshold()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StringLiteralDuplication.class, "ignoreAnnotation", "getIgnoreAnnotation()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StringLiteralDuplication.class, "excludeStringsWithLessThan5Characters", "getExcludeStringsWithLessThan5Characters()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StringLiteralDuplication.class, "ignoreStringsRegex", "getIgnoreStringsRegex()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0005J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0007H\u0016R6\u0010\u0003\u001a*\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004j\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$StringLiteralVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication;)V", "literalReferences", "Ljava/util/HashMap;", "", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "Lkotlin/collections/HashMap;", "literals", "", "pass", "", "Lkotlin/Unit;", "add", "str", "entitiesForLiteral", "Lkotlin/Pair;", "Lio/gitlab/arturbosch/detekt/api/Entity;", "", "literal", "getLiteralsOverThreshold", "", "visitStringTemplateExpression", "expression", "detekt-rules-complexity"})
    public final class StringLiteralVisitor
    extends DetektVisitor {
        @NotNull
        private final HashMap<String, Integer> literals = new HashMap();
        @NotNull
        private final HashMap<String, List<KtStringTemplateExpression>> literalReferences = new HashMap();
        @NotNull
        private final Unit pass = Unit.INSTANCE;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, Integer> getLiteralsOverThreshold() {
            void $this$filterValues$iv;
            Map map = this.literals;
            StringLiteralDuplication stringLiteralDuplication = StringLiteralDuplication.this;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                int it = ((Number)entry$iv.getValue()).intValue();
                boolean bl = false;
                if (!(it >= stringLiteralDuplication.getThreshold())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return result$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Pair<Entity, List<Entity>> entitiesForLiteral(@NotNull String literal) {
            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
            List<KtStringTemplateExpression> references = this.literalReferences.get(literal);
            if (references != null && !((Collection)references).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                KtStringTemplateExpression mainEntity = references.get(0);
                List<KtStringTemplateExpression> referenceEntities = references.subList(1, references.size());
                Iterable iterable = referenceEntities;
                Entity entity = Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)mainEntity), (int)0, (int)2, null);
                boolean $i$f$map = false;
                void var7_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null));
                }
                return TuplesKt.to((Object)entity, (Object)((List)destination$iv$iv));
            }
            throw new IllegalStateException(("No KtElements for literal '" + literal + "' found!").toString());
        }

        /*
         * Enabled aggressive block sorting
         */
        public void visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            String text = KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)expression);
            if (StringLiteralDuplication.this.getIgnoreAnnotation()) {
                PsiElement $this$isPartOf$iv = (PsiElement)expression;
                boolean $i$f$isPartOf = false;
                PsiElement $this$getNonStrictParentOfType$iv$iv = $this$isPartOf$iv;
                boolean $i$f$getNonStrictParentOfType = false;
                if (PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv$iv, KtAnnotationEntry.class, (boolean)false) != null) {
                    return;
                }
                boolean bl = false;
                if (bl) {
                    return;
                }
            }
            if (StringLiteralDuplication.this.getExcludeStringsWithLessThan5Characters() && text.length() < 5) {
                return;
            }
            CharSequence charSequence = text;
            if (StringLiteralDuplication.this.getIgnoreStringsRegex().matches(charSequence)) {
                return;
            }
            this.add(expression);
        }

        private final void add(KtStringTemplateExpression str) {
            String text = KtPsiUtilKt.getPlainContent((KtStringTemplateExpression)str);
            this.literals.compute(text, (arg_0, arg_1) -> StringLiteralVisitor.add$lambda$2(add.1.INSTANCE, arg_0, arg_1));
            this.literalReferences.compute(text, (arg_0, arg_1) -> StringLiteralVisitor.add$lambda$3((Function2)new Function2<String, List<KtStringTemplateExpression>, List<KtStringTemplateExpression>>(str){
                final /* synthetic */ KtStringTemplateExpression $str;
                {
                    this.$str = $str;
                    super(2);
                }

                @Nullable
                public final List<KtStringTemplateExpression> invoke(@NotNull String string, @Nullable List<KtStringTemplateExpression> entries) {
                    List list;
                    Intrinsics.checkNotNullParameter((Object)string, (String)"<anonymous parameter 0>");
                    List list2 = entries;
                    if (list2 != null) {
                        list2.add((KtStringTemplateExpression)this.$str);
                    }
                    if ((list = entries) == null) {
                        Object[] objectArray = new KtStringTemplateExpression[]{this.$str};
                        list = CollectionsKt.mutableListOf((Object[])objectArray);
                    }
                    return list;
                }
            }, arg_0, arg_1));
        }

        private static final Integer add$lambda$2(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Integer)$tmp0.invoke(p0, p1);
        }

        private static final List add$lambda$3(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (List)$tmp0.invoke(p0, p1);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/StringLiteralDuplication$Companion;", "", "()V", "STRING_EXCLUSION_LENGTH", "", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

