/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0019\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 A2\u00020\u0001:\u0001AB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u00100\u001a\u00020\u00062\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020\b2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J\u0010\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020<H\u0016J\u0010\u0010=\u001a\u0002072\u0006\u00104\u001a\u000205H\u0016J\u0010\u0010>\u001a\u0002072\u0006\u0010?\u001a\u00020@H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR!\u0010\u000f\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u0012\u0004\b\u0010\u0010\n\u001a\u0004\b\u0011\u0010\fR!\u0010\u0013\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u000e\u0012\u0004\b\u0014\u0010\n\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001b\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u000e\u0012\u0004\b\u001c\u0010\n\u001a\u0004\b\u001d\u0010\u001eR!\u0010 \u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u000e\u0012\u0004\b!\u0010\n\u001a\u0004\b\"\u0010\u001eR!\u0010$\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u000e\u0012\u0004\b%\u0010\n\u001a\u0004\b&\u0010\u001eR!\u0010(\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u000e\u0012\u0004\b)\u0010\n\u001a\u0004\b*\u0010\u001eR!\u0010,\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010\u000e\u0012\u0004\b-\u0010\n\u001a\u0004\b.\u0010\u001e\u00a8\u0006B"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "amountOfTopLevelFunctions", "", "ignoreDeprecated", "", "getIgnoreDeprecated$annotations", "()V", "getIgnoreDeprecated", "()Z", "ignoreDeprecated$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOverridden", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "ignoreOverridden$delegate", "ignorePrivate", "getIgnorePrivate$annotations", "getIgnorePrivate", "ignorePrivate$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "thresholdInClasses", "getThresholdInClasses$annotations", "getThresholdInClasses", "()I", "thresholdInClasses$delegate", "thresholdInEnums", "getThresholdInEnums$annotations", "getThresholdInEnums", "thresholdInEnums$delegate", "thresholdInFiles", "getThresholdInFiles$annotations", "getThresholdInFiles", "thresholdInFiles$delegate", "thresholdInInterfaces", "getThresholdInInterfaces$annotations", "getThresholdInInterfaces", "thresholdInInterfaces$delegate", "thresholdInObjects", "getThresholdInObjects$annotations", "getThresholdInObjects", "thresholdInObjects$delegate", "calcFunctions", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isIgnoredFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Companion", "detekt-rules-complexity"})
public final class TooManyFunctions
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty thresholdInFiles$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInClasses$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInInterfaces$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInObjects$delegate;
    @NotNull
    private final ReadOnlyProperty thresholdInEnums$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreDeprecated$delegate;
    @NotNull
    private final ReadOnlyProperty ignorePrivate$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;
    private int amountOfTopLevelFunctions;
    public static final int DEFAULT_THRESHOLD = 11;
    @NotNull
    private static final String DEPRECATED = "Deprecated";

    public TooManyFunctions(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("TooManyFunctions", Severity.Maintainability, "Too many functions inside a/an file/class/object/interface always indicate a violation of the single responsibility principle. Maybe the file/class/object/interface wants to manage too many things at once. Extract functionality which clearly belongs together.", Debt.Companion.getTWENTY_MINS());
        this.thresholdInFiles$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInClasses$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInInterfaces$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInObjects$delegate = ConfigPropertyKt.config((Object)11);
        this.thresholdInEnums$delegate = ConfigPropertyKt.config((Object)11);
        this.ignoreDeprecated$delegate = ConfigPropertyKt.config((Object)false);
        this.ignorePrivate$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ TooManyFunctions(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThresholdInFiles() {
        return ((Number)this.thresholdInFiles$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="threshold in files")
    private static /* synthetic */ void getThresholdInFiles$annotations() {
    }

    private final int getThresholdInClasses() {
        return ((Number)this.thresholdInClasses$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    @Configuration(description="threshold in classes")
    private static /* synthetic */ void getThresholdInClasses$annotations() {
    }

    private final int getThresholdInInterfaces() {
        return ((Number)this.thresholdInInterfaces$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    @Configuration(description="threshold in interfaces")
    private static /* synthetic */ void getThresholdInInterfaces$annotations() {
    }

    private final int getThresholdInObjects() {
        return ((Number)this.thresholdInObjects$delegate.getValue((Object)this, $$delegatedProperties[3])).intValue();
    }

    @Configuration(description="threshold in objects")
    private static /* synthetic */ void getThresholdInObjects$annotations() {
    }

    private final int getThresholdInEnums() {
        return ((Number)this.thresholdInEnums$delegate.getValue((Object)this, $$delegatedProperties[4])).intValue();
    }

    @Configuration(description="threshold in enums")
    private static /* synthetic */ void getThresholdInEnums$annotations() {
    }

    private final boolean getIgnoreDeprecated() {
        return (Boolean)this.ignoreDeprecated$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    @Configuration(description="ignore deprecated functions")
    private static /* synthetic */ void getIgnoreDeprecated$annotations() {
    }

    private final boolean getIgnorePrivate() {
        return (Boolean)this.ignorePrivate$delegate.getValue((Object)this, $$delegatedProperties[6]);
    }

    @Configuration(description="ignore private functions")
    private static /* synthetic */ void getIgnorePrivate$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[7]);
    }

    @Configuration(description="ignore overridden functions")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        if (this.amountOfTopLevelFunctions >= this.getThresholdInFiles()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atPackageOrFirstDecl(file), new Metric("SIZE", this.amountOfTopLevelFunctions, this.getThresholdInFiles(), false, 0, 24, null), "File '" + file.getName() + "' with '" + this.amountOfTopLevelFunctions + "' functions detected. Defined threshold inside files is set to '" + this.getThresholdInFiles() + '\'', null, 16, null));
        }
        this.amountOfTopLevelFunctions = 0;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.isTopLevel() && !this.isIgnoredFunction(function)) {
            int n = this.amountOfTopLevelFunctions;
            this.amountOfTopLevelFunctions = n + 1;
        }
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        int amount = this.calcFunctions((KtClassOrObject)klass);
        if (klass.isInterface()) {
            if (amount >= this.getThresholdInInterfaces()) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), new Metric("SIZE", amount, this.getThresholdInInterfaces(), false, 0, 24, null), "Interface '" + klass.getName() + "' with '" + amount + "' functions detected. Defined threshold inside interfaces is set to '" + this.getThresholdInInterfaces() + '\'', null, 16, null));
            }
        } else if (klass.isEnum()) {
            if (amount >= this.getThresholdInEnums()) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), new Metric("SIZE", amount, this.getThresholdInEnums(), false, 0, 24, null), "Enum class '" + klass.getName() + "' with '" + amount + "' functions detected. Defined threshold inside enum classes is set to '" + this.getThresholdInEnums() + '\'', null, 16, null));
            }
        } else if (amount >= this.getThresholdInClasses()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), new Metric("SIZE", amount, this.getThresholdInClasses(), false, 0, 24, null), "Class '" + klass.getName() + "' with '" + amount + "' functions detected. Defined threshold inside classes is set to '" + this.getThresholdInClasses() + '\'', null, 16, null));
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        int amount = this.calcFunctions((KtClassOrObject)declaration);
        if (amount >= this.getThresholdInObjects()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)declaration), new Metric("SIZE", amount, this.getThresholdInObjects(), false, 0, 24, null), "Object '" + declaration.getName() + "' with '" + amount + "' functions detected. Defined threshold inside objects is set to '" + this.getThresholdInObjects() + '\'', null, 16, null));
        }
        super.visitObjectDeclaration(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final int calcFunctions(KtClassOrObject classOrObject) {
        int n;
        KtClassBody ktClassBody = classOrObject.getBody();
        if (ktClassBody != null) {
            void $this$count$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            KtClassBody $this$calcFunctions_u24lambda_u241 = ktClassBody;
            boolean bl = false;
            Iterable iterable = $this$calcFunctions_u24lambda_u241.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            void var7_7 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KtNamedFunction it = (KtNamedFunction)element$iv;
                    boolean bl2 = false;
                    if (!(!this.isIgnoredFunction(it)) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isIgnoredFunction(KtNamedFunction function) {
        String[] stringArray;
        return this.getIgnoreDeprecated() && KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)((KtAnnotated)function), (String[])(stringArray = new String[]{DEPRECATED})) ? true : (this.getIgnorePrivate() && KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)function)) ? true : this.getIgnoreOverridden() && KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function)));
    }

    public TooManyFunctions() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInFiles", "getThresholdInFiles()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInClasses", "getThresholdInClasses()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInInterfaces", "getThresholdInInterfaces()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInObjects", "getThresholdInObjects()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "thresholdInEnums", "getThresholdInEnums()I", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "ignoreDeprecated", "getIgnoreDeprecated()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "ignorePrivate", "getIgnorePrivate()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(TooManyFunctions.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions$Companion;", "", "()V", "DEFAULT_THRESHOLD", "", "DEPRECATED", "", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

