/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.github.detekt.metrics.CyclomaticComplexity;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u00020\u00182\b\u0010.\u001a\u0004\u0018\u00010/H\u0002J\f\u00100\u001a\u00020\u0018*\u00020/H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u00020\u00108BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0017\u001a\u00020\u00188BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0016\u0012\u0004\b\u0019\u0010\u0012\u001a\u0004\b\u001a\u0010\u001bR!\u0010\u001d\u001a\u00020\u00188BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b \u0010\u0016\u0012\u0004\b\u001e\u0010\u0012\u001a\u0004\b\u001f\u0010\u001bR!\u0010!\u001a\u00020\u00188BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b$\u0010\u0016\u0012\u0004\b\"\u0010\u0012\u001a\u0004\b#\u0010\u001bR'\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b(\u0010\u0016\u0012\u0004\b&\u0010\u0012\u001a\u0004\b'\u0010\u000e\u00a8\u00062"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/CyclomaticComplexMethod;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreSingleWhenExpression", "", "getIgnoreSingleWhenExpression$annotations", "getIgnoreSingleWhenExpression", "()Z", "ignoreSingleWhenExpression$delegate", "ignoreSimpleWhenEntries", "getIgnoreSimpleWhenEntries$annotations", "getIgnoreSimpleWhenEntries", "ignoreSimpleWhenEntries$delegate", "ignoreNestingFunctions", "getIgnoreNestingFunctions$annotations", "getIgnoreNestingFunctions", "ignoreNestingFunctions$delegate", "nestingFunctions", "getNestingFunctions$annotations", "getNestingFunctions", "nestingFunctions$delegate", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hasSingleWhenExpression", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "returnsWhenExpression", "Companion", "detekt-rules-complexity"})
public final class CyclomaticComplexMethod
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreSingleWhenExpression$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreSimpleWhenEntries$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreNestingFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty nestingFunctions$delegate;
    @NotNull
    private static final List<String> DEFAULT_NESTING_FUNCTIONS;

    public CyclomaticComplexMethod(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("CyclomaticComplexMethod", Severity.Maintainability, "Prefer splitting up complex methods into smaller, easier to test methods.", Debt.Companion.getTWENTY_MINS());
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"ComplexMethod");
        this.threshold$delegate = ConfigPropertyKt.config((Object)15);
        this.ignoreSingleWhenExpression$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreSimpleWhenEntries$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreNestingFunctions$delegate = ConfigPropertyKt.config((Object)false);
        this.nestingFunctions$delegate = ConfigPropertyKt.config(DEFAULT_NESTING_FUNCTIONS, CyclomaticComplexMethod::nestingFunctions_delegate$lambda$0);
    }

    public /* synthetic */ CyclomaticComplexMethod(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="McCabe's Cyclomatic Complexity (MCC) number for a method.")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final boolean getIgnoreSingleWhenExpression() {
        return (Boolean)this.ignoreSingleWhenExpression$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="Ignores a complex method if it only contains a single when expression.")
    private static /* synthetic */ void getIgnoreSingleWhenExpression$annotations() {
    }

    private final boolean getIgnoreSimpleWhenEntries() {
        return (Boolean)this.ignoreSimpleWhenEntries$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="Whether to ignore simple (braceless) when entries.")
    private static /* synthetic */ void getIgnoreSimpleWhenEntries$annotations() {
    }

    private final boolean getIgnoreNestingFunctions() {
        return (Boolean)this.ignoreNestingFunctions$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="Whether to ignore functions which are often used instead of an `if` or `for` statement.")
    private static /* synthetic */ void getIgnoreNestingFunctions$annotations() {
    }

    private final Set<String> getNestingFunctions() {
        return (Set)this.nestingFunctions$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    @Configuration(description="Comma separated list of function names which add complexity.")
    private static /* synthetic */ void getNestingFunctions$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (this.getIgnoreSingleWhenExpression() && this.hasSingleWhenExpression(function.getBodyExpression())) {
            return;
        }
        int complexity = CyclomaticComplexity.Companion.calculate((KtElement)function, arg_0 -> CyclomaticComplexMethod.visitNamedFunction$lambda$1(this, arg_0));
        if (complexity >= this.getThreshold()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), new Metric("MCC", complexity, this.getThreshold(), false, 0, 24, null), "The function " + function.getNameAsSafeName() + " appears to be too complex based on Cyclomatic Complexity (complexity: " + complexity + "). Defined complexity threshold for methods is set to '" + this.getThreshold() + '\'', null, 16, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasSingleWhenExpression(KtExpression bodyExpression) {
        if (bodyExpression instanceof KtBlockExpression && ((KtBlockExpression)bodyExpression).getStatements().size() == 1) {
            List list = ((KtBlockExpression)bodyExpression).getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStatements(...)");
            KtExpression statement = (KtExpression)CollectionsKt.single((List)list);
            if (statement instanceof KtWhenExpression) return true;
            Intrinsics.checkNotNull((Object)statement);
            if (!this.returnsWhenExpression(statement)) return false;
            return true;
        }
        if (!(bodyExpression instanceof KtWhenExpression)) return false;
        return true;
    }

    private final boolean returnsWhenExpression(KtExpression $this$returnsWhenExpression) {
        return $this$returnsWhenExpression instanceof KtReturnExpression && ((KtReturnExpression)$this$returnsWhenExpression).getReturnedExpression() instanceof KtWhenExpression;
    }

    private static final Set nestingFunctions_delegate$lambda$0(List it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CollectionsKt.toSet((Iterable)it);
    }

    private static final Unit visitNamedFunction$lambda$1(CyclomaticComplexMethod this$0, CyclomaticComplexity.Config $this$calculate) {
        Intrinsics.checkNotNullParameter((Object)$this$calculate, (String)"$this$calculate");
        $this$calculate.setIgnoreSimpleWhenEntries(this$0.getIgnoreSimpleWhenEntries());
        $this$calculate.setIgnoreNestingFunctions(this$0.getIgnoreNestingFunctions());
        $this$calculate.setNestingFunctions(this$0.getNestingFunctions());
        return Unit.INSTANCE;
    }

    public CyclomaticComplexMethod() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "threshold", "getThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "ignoreSingleWhenExpression", "getIgnoreSingleWhenExpression()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "ignoreSimpleWhenEntries", "getIgnoreSimpleWhenEntries()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "ignoreNestingFunctions", "getIgnoreNestingFunctions()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CyclomaticComplexMethod.class, "nestingFunctions", "getNestingFunctions()Ljava/util/Set;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"also", "apply", "forEach", "isNotNull", "ifNull", "let", "run", "use", "with"};
        DEFAULT_NESTING_FUNCTIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/CyclomaticComplexMethod$Companion;", "", "<init>", "()V", "DEFAULT_NESTING_FUNCTIONS", "", "", "getDEFAULT_NESTING_FUNCTIONS", "()Ljava/util/List;", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDEFAULT_NESTING_FUNCTIONS() {
            return DEFAULT_NESTING_FUNCTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

