/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty0;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 E2\u00020\u0001:\u0001EB\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020.2\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u00020.2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020.2\u0006\u00105\u001a\u000208H\u0016J\f\u00109\u001a\u00020\u001b*\u00020:H\u0002J\u0014\u0010;\u001a\u00020.2\n\u00105\u001a\u0006\u0012\u0002\b\u00030<H\u0002J\f\u0010=\u001a\u00020\u001b*\u00020>H\u0002J \u0010?\u001a\u00020.2\u0006\u00102\u001a\u00020@2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010A\u001a\u00020BH\u0002J\f\u0010C\u001a\u00020\u000b*\u00020DH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000fR!\u0010\u001a\u001a\u00020\u001b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0011\u0012\u0004\b\u001c\u0010\r\u001a\u0004\b\u001d\u0010\u001eR!\u0010 \u001a\u00020\u001b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u0011\u0012\u0004\b!\u0010\r\u001a\u0004\b\"\u0010\u001eR'\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010\u0011\u0012\u0004\b'\u0010\r\u001a\u0004\b(\u0010)R\u000e\u0010+\u001a\u00020,X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "functionThreshold", "getFunctionThreshold$annotations", "getFunctionThreshold", "functionThreshold$delegate", "constructorThreshold", "getConstructorThreshold$annotations", "getConstructorThreshold", "constructorThreshold$delegate", "ignoreDefaultParameters", "", "getIgnoreDefaultParameters$annotations", "getIgnoreDefaultParameters", "()Z", "ignoreDefaultParameters$delegate", "ignoreDataClasses", "getIgnoreDataClasses$annotations", "getIgnoreDataClasses", "ignoreDataClasses$delegate", "ignoreAnnotatedParameter", "", "Lkotlin/text/Regex;", "getIgnoreAnnotatedParameter$annotations", "getIgnoreAnnotatedParameter", "()Ljava/util/List;", "ignoreAnnotatedParameter$delegate", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "isIgnored", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "validateConstructor", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "isDataClassOrIgnored", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkLongParameterList", "Lorg/jetbrains/kotlin/psi/KtFunction;", "identifier", "", "parameterCount", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "Companion", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nLongParameterList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LongParameterList.kt\nio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n774#2:140\n865#2,2:141\n1782#2,4:143\n1557#2:147\n1628#2,3:148\n*S KotlinDebug\n*F\n+ 1 LongParameterList.kt\nio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList\n*L\n126#1:140\n126#1:141,2\n128#1:143,4\n67#1:147\n67#1:148,3\n*E\n"})
public final class LongParameterList
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty functionThreshold$delegate;
    @NotNull
    private final ReadOnlyProperty constructorThreshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreDefaultParameters$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreDataClasses$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreAnnotatedParameter$delegate;
    private AnnotationExcluder annotationExcluder;
    private static final int DEFAULT_FUNCTION_THRESHOLD = 6;
    private static final int DEFAULT_CONSTRUCTOR_THRESHOLD = 7;

    public LongParameterList(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("LongParameterList", Severity.Maintainability, "The more parameters a function has the more complex it is. Long parameter lists are often used to control complex algorithms and violate the Single Responsibility Principle. Prefer functions with short parameter lists.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)6);
        this.functionThreshold$delegate = ConfigPropertyKt.configWithFallback((KProperty0)((KProperty0)new PropertyReference0Impl((Object)this){

            public Object get() {
                return LongParameterList.access$getThreshold((LongParameterList)((Object)this.receiver));
            }
        }), (Object)6);
        this.constructorThreshold$delegate = ConfigPropertyKt.configWithFallback((KProperty0)((KProperty0)new PropertyReference0Impl((Object)this){

            public Object get() {
                return LongParameterList.access$getThreshold((LongParameterList)((Object)this.receiver));
            }
        }), (Object)7);
        this.ignoreDefaultParameters$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreDataClasses$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreAnnotatedParameter$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), LongParameterList::ignoreAnnotatedParameter_delegate$lambda$1);
    }

    public /* synthetic */ LongParameterList(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Deprecated(message="Use `functionThreshold` and `constructorThreshold` instead")
    @Configuration(description="number of parameters required to trigger the rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final int getFunctionThreshold() {
        return ((Number)this.functionThreshold$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    @Configuration(description="number of function parameters required to trigger the rule")
    private static /* synthetic */ void getFunctionThreshold$annotations() {
    }

    private final int getConstructorThreshold() {
        return ((Number)this.constructorThreshold$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    @Configuration(description="number of constructor parameters required to trigger the rule")
    private static /* synthetic */ void getConstructorThreshold$annotations() {
    }

    private final boolean getIgnoreDefaultParameters() {
        return (Boolean)this.ignoreDefaultParameters$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignore parameters that have a default value")
    private static /* synthetic */ void getIgnoreDefaultParameters$annotations() {
    }

    private final boolean getIgnoreDataClasses() {
        return (Boolean)this.ignoreDataClasses$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    @Configuration(description="ignore long constructor parameters list for data classes")
    private static /* synthetic */ void getIgnoreDataClasses$annotations() {
    }

    private final List<Regex> getIgnoreAnnotatedParameter() {
        return (List)this.ignoreAnnotatedParameter$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    @Configuration(description="ignore the annotated parameters for the count (e.g. `fun foo(@Value bar: Int)` would not be counted")
    private static /* synthetic */ void getIgnoreAnnotatedParameter$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.annotationExcluder = new AnnotationExcluder(file, this.getIgnoreAnnotatedParameter(), this.getBindingContext());
        super.visitKtFile(file);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        this.checkLongParameterList((KtFunction)function, this.getFunctionThreshold(), "function " + function.getNameAsSafeName());
    }

    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.validateConstructor((KtConstructor)constructor);
    }

    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.validateConstructor((KtConstructor)constructor);
    }

    private final boolean isIgnored(KtAnnotated $this$isIgnored) {
        AnnotationExcluder annotationExcluder = this.annotationExcluder;
        if (annotationExcluder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
            annotationExcluder = null;
        }
        List list = $this$isIgnored.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAnnotationEntries(...)");
        return annotationExcluder.shouldExclude(list);
    }

    private final void validateConstructor(KtConstructor<?> constructor) {
        KtClassOrObject owner = constructor.getContainingClassOrObject();
        if (owner instanceof KtClass && this.isDataClassOrIgnored((KtClass)owner)) {
            return;
        }
        this.checkLongParameterList((KtFunction)constructor, this.getConstructorThreshold(), "constructor");
    }

    private final boolean isDataClassOrIgnored(KtClass $this$isDataClassOrIgnored) {
        return this.getIgnoreDataClasses() && $this$isDataClassOrIgnored.isData();
    }

    private final void checkLongParameterList(KtFunction function, int threshold, String identifier) {
        if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function))) {
            return;
        }
        KtParameterList ktParameterList = function.getValueParameterList();
        if (ktParameterList == null) {
            return;
        }
        KtParameterList parameterList = ktParameterList;
        int parameterNumber = this.parameterCount(parameterList);
        if (parameterNumber >= threshold) {
            List list = function.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            String parameterPrint = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, LongParameterList::checkLongParameterList$lambda$2, (int)30, null);
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameterList), (int)0, (int)2, null), new Metric("SIZE", parameterNumber, threshold, false, 0, 24, null), "The " + identifier + '(' + parameterPrint + ") has too many parameters. The current threshold is set to " + threshold + '.', null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int parameterCount(KtParameterList $this$parameterCount) {
        int n;
        void $this$filterTo$iv$iv;
        List list = $this$parameterCount.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParameters(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtParameter it = (KtParameter)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!(!this.isIgnored((KtAnnotated)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List preFilteredParameters = (List)destination$iv$iv;
        if (this.getIgnoreDefaultParameters()) {
            Iterable $this$count$iv = preFilteredParameters;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KtParameter it = (KtParameter)element$iv;
                    boolean bl = false;
                    if (!(!it.hasDefaultValue()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = preFilteredParameters.size();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final List ignoreAnnotatedParameter_delegate$lambda$1(List list) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Regex(StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)".*", (boolean)false, (int)4, null)));
        }
        return (List)destination$iv$iv;
    }

    private static final CharSequence checkLongParameterList$lambda$2(KtParameter it) {
        KtTypeReference ktTypeReference = it.getTypeReference();
        return it.getNameAsSafeName().getIdentifier() + ": " + (ktTypeReference != null ? ktTypeReference.getText() : null);
    }

    public LongParameterList() {
        this(null, 1, null);
    }

    public static final /* synthetic */ int access$getThreshold(LongParameterList $this) {
        return $this.getThreshold();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LongParameterList.class, "threshold", "getThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LongParameterList.class, "functionThreshold", "getFunctionThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LongParameterList.class, "constructorThreshold", "getConstructorThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LongParameterList.class, "ignoreDefaultParameters", "getIgnoreDefaultParameters()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LongParameterList.class, "ignoreDataClasses", "getIgnoreDataClasses()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(LongParameterList.class, "ignoreAnnotatedParameter", "getIgnoreAnnotatedParameter()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList$Companion;", "", "<init>", "()V", "DEFAULT_FUNCTION_THRESHOLD", "", "DEFAULT_CONSTRUCTOR_THRESHOLD", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

