/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.github.detekt.tooling.api.FunctionMatcher;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 !2\u00020\u0001:\u0002!\"B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR'\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0011\u0012\u0004\b\u0015\u0010\r\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "functions", "", "Lio/github/detekt/tooling/api/FunctionMatcher;", "getFunctions$annotations", "getFunctions", "()Ljava/util/List;", "functions$delegate", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "report", "element", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "depth", "Companion", "FunctionDepthVisitor", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nNestedScopeFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedScopeFunctions.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1557#2:134\n1628#2,3:135\n*S KotlinDebug\n*F\n+ 1 NestedScopeFunctions.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions\n*L\n64#1:134\n64#1:135,3\n*E\n"})
public final class NestedScopeFunctions
extends Rule {
    @NotNull
    private static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty functions$delegate;
    @NotNull
    private static final List<String> DEFAULT_FUNCTIONS;

    public NestedScopeFunctions(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Maintainability, "Over-using scope functions makes code confusing, hard to read and bug prone.", Debt.Companion.getFIVE_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)1);
        this.functions$delegate = ConfigPropertyKt.config(DEFAULT_FUNCTIONS, NestedScopeFunctions::functions_delegate$lambda$0);
    }

    public /* synthetic */ NestedScopeFunctions(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="Number of nested scope functions allowed.")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final List<FunctionMatcher> getFunctions() {
        return (List)this.functions$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="Set of scope function names which add complexity. Function names have to be fully qualified. For example 'kotlin.apply'.")
    private static /* synthetic */ void getFunctions$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        function.accept((PsiElementVisitor)new FunctionDepthVisitor());
    }

    private final void report(KtCallExpression element, int depth) {
        KtExpression ktExpression = element.getCalleeExpression();
        ThresholdedCodeSmell finding = new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)element), (int)0, (int)2, null), new Metric("SIZE", depth, this.getThreshold(), false, 0, 24, null), "The scope function '" + (ktExpression != null ? ktExpression.getText() : null) + "' is nested too deeply ('" + depth + "'). Complexity threshold is set to '" + this.getThreshold() + "'.", null, 16, null);
        this.report((Finding)finding);
    }

    /*
     * WARNING - void declaration
     */
    private static final List functions_delegate$lambda$0(List it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable iterable = CollectionsKt.toSet((Iterable)it);
        FunctionMatcher.Companion companion = FunctionMatcher.Companion;
        boolean $i$f$map = false;
        void var4_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            boolean $i$f$functions_delegate$lambda$0$stub_for_inlining = false;
            collection.add(companion.fromFunctionSignature((String)p0));
        }
        return (List)destination$iv$iv;
    }

    public NestedScopeFunctions() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NestedScopeFunctions.class, "threshold", "getThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NestedScopeFunctions.class, "functions", "getFunctions()Ljava/util/List;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"kotlin.apply", "kotlin.run", "kotlin.with", "kotlin.let", "kotlin.also"};
        DEFAULT_FUNCTIONS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions$Companion;", "", "<init>", "()V", "DEFAULT_FUNCTIONS", "", "", "getDEFAULT_FUNCTIONS", "()Ljava/util/List;", "detekt-rules-complexity"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDEFAULT_FUNCTIONS() {
            return DEFAULT_FUNCTIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\f\u0010\u000e\u001a\u00020\u000f*\u00020\tH\u0002J\u0014\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011*\u00020\tH\u0002J\f\u0010\u0013\u001a\u00020\u000f*\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions$FunctionDepthVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "<init>", "(Lio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions;)V", "depth", "", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "doWithIncrementedDepth", "block", "Lkotlin/Function0;", "reportIfOverThreshold", "isScopeFunction", "", "resolveDescriptors", "", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "matchesScopeFunction", "detekt-rules-complexity"})
    @SourceDebugExtension(value={"SMAP\nNestedScopeFunctions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NestedScopeFunctions.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions$FunctionDepthVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1755#2,3:134\n1755#2,3:138\n1#3:137\n*S KotlinDebug\n*F\n+ 1 NestedScopeFunctions.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NestedScopeFunctions$FunctionDepthVisitor\n*L\n122#1:134,3\n130#1:138,3\n*E\n"})
    private final class FunctionDepthVisitor
    extends DetektVisitor {
        private int depth;

        public void visitCallExpression(@NotNull KtCallExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            if (this.isScopeFunction(expression)) {
                this.doWithIncrementedDepth((Function0<Unit>)((Function0)() -> FunctionDepthVisitor.visitCallExpression$lambda$0(this, expression)));
            } else {
                FunctionDepthVisitor.visitCallExpression$callSuper(this, expression);
            }
        }

        private final void doWithIncrementedDepth(Function0<Unit> block) {
            int n = this.depth;
            this.depth = n + 1;
            block.invoke();
            n = this.depth;
            this.depth = n + -1;
        }

        private final void reportIfOverThreshold(KtCallExpression expression) {
            if (this.depth > NestedScopeFunctions.this.getThreshold()) {
                NestedScopeFunctions.this.report(expression, this.depth);
            }
        }

        private final boolean isScopeFunction(KtCallExpression $this$isScopeFunction) {
            boolean bl;
            block4: {
                List<CallableDescriptor> list = this.resolveDescriptors($this$isScopeFunction);
                if (list == null) {
                    return false;
                }
                List<CallableDescriptor> descriptors = list;
                Iterable $this$any$iv = descriptors;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CallableDescriptor it = (CallableDescriptor)element$iv;
                        boolean bl2 = false;
                        if (!this.matchesScopeFunction(it)) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<CallableDescriptor> resolveDescriptors(KtCallExpression $this$resolveDescriptors) {
            List list;
            CallableDescriptor callableDescriptor;
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$resolveDescriptors), (BindingContext)NestedScopeFunctions.this.getBindingContext());
            if (resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null) {
                CallableDescriptor it = callableDescriptor;
                boolean bl = false;
                Collection collection = CollectionsKt.listOf((Object)it);
                Collection collection2 = it.getOverriddenDescriptors();
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getOverriddenDescriptors(...)");
                list = CollectionsKt.plus((Collection)collection, (Iterable)collection2);
            } else {
                list = null;
            }
            return list;
        }

        private final boolean matchesScopeFunction(CallableDescriptor $this$matchesScopeFunction) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = NestedScopeFunctions.this.getFunctions();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FunctionMatcher it = (FunctionMatcher)element$iv;
                        boolean bl2 = false;
                        if (!it.match($this$matchesScopeFunction)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private static final void visitCallExpression$callSuper(FunctionDepthVisitor this$0, KtCallExpression $expression) {
            super.visitCallExpression($expression);
        }

        private static final Unit visitCallExpression$lambda$0(FunctionDepthVisitor this$0, KtCallExpression $expression) {
            this$0.reportIfOverThreshold($expression);
            FunctionDepthVisitor.visitCallExpression$callSuper(this$0, $expression);
            return Unit.INSTANCE;
        }
    }
}

