/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.documentation.UndocumentedPublicFunction$shouldBeDocumented$;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicFunction;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "shouldBeDocumented", "", "detekt-rules-documentation"})
public final class UndocumentedPublicFunction
extends Rule {
    @NotNull
    private final Issue issue;

    public UndocumentedPublicFunction(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Public functions require documentation.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ UndocumentedPublicFunction(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (function.getFunKeyword() == null && function.isLocal()) {
            return;
        }
        if (function.getDocComment() == null && this.shouldBeDocumented(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "The function " + function.getNameAsSafeName() + " is missing documentation.", null, null, 24, null));
        }
    }

    private final boolean shouldBeDocumented(KtNamedFunction $this$shouldBeDocumented) {
        boolean bl;
        block2: {
            Sequence $this$filterIsInstance$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)$this$shouldBeDocumented));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)shouldBeDocumented$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            Sequence $this$all$iv = sequence;
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                KtClassOrObject it = (KtClassOrObject)element$iv;
                boolean bl2 = false;
                if (KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)it))) continue;
                bl = false;
                break block2;
            }
            bl = true;
        }
        return bl && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)((KtModifierListOwner)$this$shouldBeDocumented));
    }

    public UndocumentedPublicFunction() {
        this(null, 1, null);
    }
}

