/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.documentation;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.TraversingKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(H\u0016J\f\u0010)\u001a\u00020\n*\u00020(H\u0002J\f\u0010*\u001a\u00020\n*\u00020$H\u0002J\f\u0010+\u001a\u00020\n*\u00020$H\u0002J\f\u0010,\u001a\u00020\n*\u00020$H\u0002J\f\u0010-\u001a\u00020\n*\u00020\u001fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR!\u0010\u0011\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0010\u0012\u0004\b\u0012\u0010\f\u001a\u0004\b\u0013\u0010\u000eR!\u0010\u0015\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0010\u0012\u0004\b\u0016\u0010\f\u001a\u0004\b\u0017\u0010\u000eR!\u0010\u0019\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0010\u0012\u0004\b\u001a\u0010\f\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006."}, d2={"Lio/gitlab/arturbosch/detekt/rules/documentation/UndocumentedPublicClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "searchInInnerClass", "", "getSearchInInnerClass$annotations", "()V", "getSearchInInnerClass", "()Z", "searchInInnerClass$delegate", "Lkotlin/properties/ReadOnlyProperty;", "searchInInnerInterface", "getSearchInInnerInterface$annotations", "getSearchInInnerInterface", "searchInInnerInterface$delegate", "searchInInnerObject", "getSearchInInnerObject$annotations", "getSearchInInnerObject", "searchInInnerObject$delegate", "searchInNestedClass", "getSearchInNestedClass$annotations", "getSearchInNestedClass", "searchInNestedClass$delegate", "isPublicAndPublicInherited", "element", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "reportIfUndocumented", "", "requiresDocumentation", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitClass", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "isCompanionWithoutName", "isInnerClass", "isInnerInterface", "isNestedClass", "notEnumEntry", "detekt-rules-documentation"})
public final class UndocumentedPublicClass
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty searchInNestedClass$delegate;
    @NotNull
    private final ReadOnlyProperty searchInInnerClass$delegate;
    @NotNull
    private final ReadOnlyProperty searchInInnerObject$delegate;
    @NotNull
    private final ReadOnlyProperty searchInInnerInterface$delegate;

    public UndocumentedPublicClass(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "Public classes, interfaces and objects require documentation.", Debt.Companion.getTWENTY_MINS());
        this.searchInNestedClass$delegate = ConfigPropertyKt.config((Object)true);
        this.searchInInnerClass$delegate = ConfigPropertyKt.config((Object)true);
        this.searchInInnerObject$delegate = ConfigPropertyKt.config((Object)true);
        this.searchInInnerInterface$delegate = ConfigPropertyKt.config((Object)true);
    }

    public /* synthetic */ UndocumentedPublicClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getSearchInNestedClass() {
        return (Boolean)this.searchInNestedClass$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if nested classes should be searched")
    private static /* synthetic */ void getSearchInNestedClass$annotations() {
    }

    private final boolean getSearchInInnerClass() {
        return (Boolean)this.searchInInnerClass$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="if inner classes should be searched")
    private static /* synthetic */ void getSearchInInnerClass$annotations() {
    }

    private final boolean getSearchInInnerObject() {
        return (Boolean)this.searchInInnerObject$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="if inner objects should be searched")
    private static /* synthetic */ void getSearchInInnerObject$annotations() {
    }

    private final boolean getSearchInInnerInterface() {
        return (Boolean)this.searchInInnerInterface$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="if inner interfaces should be searched")
    private static /* synthetic */ void getSearchInInnerInterface$annotations() {
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (this.requiresDocumentation(klass)) {
            this.reportIfUndocumented((KtClassOrObject)klass);
        }
        super.visitClass(klass);
    }

    private final boolean requiresDocumentation(KtClass klass) {
        return klass.isTopLevel() || this.isInnerClass(klass) || this.isNestedClass(klass) || this.isInnerInterface(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.isCompanionWithoutName(declaration) || declaration.isLocal() || !this.getSearchInInnerObject()) {
            return;
        }
        this.reportIfUndocumented((KtClassOrObject)declaration);
        super.visitObjectDeclaration(declaration);
    }

    private final void reportIfUndocumented(KtClassOrObject element) {
        if (this.isPublicAndPublicInherited(element) && this.notEnumEntry(element) && element.getDocComment() == null) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)element), element.getNameAsSafeName() + " is missing required documentation.", null, null, 24, null));
        }
    }

    private final boolean isPublicAndPublicInherited(KtClassOrObject element) {
        return TraversingKt.isPublicInherited((KtNamedDeclaration)((KtNamedDeclaration)element)) && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)((KtModifierListOwner)element));
    }

    private final boolean isCompanionWithoutName(KtObjectDeclaration $this$isCompanionWithoutName) {
        return $this$isCompanionWithoutName.isCompanion() && Intrinsics.areEqual((Object)$this$isCompanionWithoutName.getNameAsSafeName().asString(), (Object)"Companion");
    }

    private final boolean isNestedClass(KtClass $this$isNestedClass) {
        return !$this$isNestedClass.isInterface() && !$this$isNestedClass.isTopLevel() && !$this$isNestedClass.isInner() && this.getSearchInNestedClass();
    }

    private final boolean isInnerClass(KtClass $this$isInnerClass) {
        return !$this$isInnerClass.isInterface() && $this$isInnerClass.isInner() && this.getSearchInInnerClass();
    }

    private final boolean isInnerInterface(KtClass $this$isInnerInterface) {
        return !$this$isInnerInterface.isTopLevel() && $this$isInnerInterface.isInterface() && this.getSearchInInnerInterface();
    }

    private final boolean notEnumEntry(KtClassOrObject $this$notEnumEntry) {
        return !($this$notEnumEntry instanceof KtEnumEntry);
    }

    public UndocumentedPublicClass() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInNestedClass", "getSearchInNestedClass()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInInnerClass", "getSearchInInnerClass()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInInnerObject", "getSearchInInnerObject()Z", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(UndocumentedPublicClass.class, "searchInInnerInterface", "getSearchInInnerInterface()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

