/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.empty;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.empty.EmptyCatchBlock;
import io.gitlab.arturbosch.detekt.rules.empty.EmptyRule;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyCatchBlock;", "Lio/gitlab/arturbosch/detekt/rules/empty/EmptyRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex$annotations", "()V", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "detekt-rules-empty"})
public final class EmptyCatchBlock
extends EmptyRule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ReadOnlyProperty allowedExceptionNameRegex$delegate;

    public EmptyCatchBlock(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, "Empty catch block detected. Empty catch blocks indicate that an exception is ignored and not handled.", "Empty catch block detected. If the exception can be safely ignored, name the exception according to one of the exemptions as per the configuration of this rule.");
        this.allowedExceptionNameRegex$delegate = ConfigPropertyKt.config((Object)"_|(ignore|expected).*", (Function1)allowedExceptionNameRegex.2.INSTANCE);
    }

    private final Regex getAllowedExceptionNameRegex() {
        return (Regex)this.allowedExceptionNameRegex$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="ignores exception types which match this regex")
    private static /* synthetic */ void getAllowedExceptionNameRegex$annotations() {
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
        super.visitCatchSection(catchClause);
        if (AllowedExceptionNamePatternKt.isAllowedExceptionName((KtCatchClause)catchClause, (Regex)this.getAllowedExceptionNameRegex())) {
            return;
        }
        KtExpression ktExpression = catchClause.getCatchBody();
        if (ktExpression != null) {
            this.addFindingIfBlockExprIsEmpty(ktExpression);
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(EmptyCatchBlock.class, "allowedExceptionNameRegex", "getAllowedExceptionNameRegex()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

