/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.empty;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.rules.empty.EmptyRule;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyIfBlock;", "Lio/gitlab/arturbosch/detekt/rules/empty/EmptyRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "checkThenBodyForLoneSemicolon", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitIfExpression", "detekt-rules-empty"})
public final class EmptyIfBlock
extends EmptyRule {
    public EmptyIfBlock(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, null, 6, null);
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIfExpression(expression);
        KtExpression ktExpression = expression.getThen();
        if (ktExpression == null) {
            this.checkThenBodyForLoneSemicolon(expression);
        } else {
            this.addFindingIfBlockExprIsEmpty(ktExpression);
        }
    }

    private final void checkThenBodyForLoneSemicolon(KtIfExpression expression) {
        String string;
        PsiElement psiElement = expression.getNextSibling();
        Object object = psiElement instanceof LeafPsiElement ? (LeafPsiElement)psiElement : null;
        IElementType iElementType = object == null ? null : object.getElementType();
        KtSingleValueToken valueOfNextSibling = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
        if ((iElementType = valueOfNextSibling) == null) {
            string = null;
        } else {
            object = iElementType.getValue();
            if (object == null) {
                string = null;
            } else {
                psiElement = object;
                boolean bl = false;
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)psiElement))).toString();
            }
        }
        if (Intrinsics.areEqual(string, (Object)";")) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This if block is empty and can be removed.", null, null, 24, null));
        }
    }
}

