/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DontDowncastCollectionTypes;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkForDowncast", "", "parent", "Lorg/jetbrains/kotlin/psi/KtExpression;", "left", "right", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "visitBinaryWithTypeRHSExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitIsExpression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "Companion", "detekt-rules-errorprone"})
public final class DontDowncastCollectionTypes
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<String> immutableTypes;
    @NotNull
    private static final List<String> mutableTypes;

    public DontDowncastCollectionTypes(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("DontDowncastCollectionTypes", Severity.Warning, "Down-casting immutable collection types is breaking the collection contract", Debt.Companion.getTEN_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIsExpression(@NotNull KtIsExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIsExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtExpression ktExpression = (KtExpression)expression;
        KtExpression ktExpression2 = expression.getLeftHandSide();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"expression.leftHandSide");
        this.checkForDowncast(ktExpression, ktExpression2, expression.getTypeReference());
    }

    public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryWithTypeRHSExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtExpression ktExpression = (KtExpression)expression;
        KtExpression ktExpression2 = expression.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"expression.left");
        this.checkForDowncast(ktExpression, ktExpression2, expression.getRight());
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForDowncast(KtExpression parent, KtExpression left, KtTypeReference right) {
        String rhsType;
        String string;
        Name name;
        FqName fqName;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)left, (BindingContext)this.getBindingContext());
        String lhsType = kotlinType == null ? null : ((fqName = TypeUtilsKt.fqNameOrNull((KotlinType)kotlinType)) == null ? null : ((name = fqName.shortNameOrSpecial()) == null ? null : name.asString()));
        fqName = right;
        if (fqName == null) {
            string = null;
        } else {
            name = fqName.getTypeElement();
            if (name == null) {
                string = null;
            } else {
                KtUserType ktUserType;
                void $this$safeAs$iv;
                Name name2 = name;
                boolean $i$f$safeAs = false;
                Object v1 = $this$safeAs$iv;
                if (!(v1 instanceof KtUserType)) {
                    v1 = null;
                }
                string = rhsType = (ktUserType = (KtUserType)v1) == null ? null : ktUserType.getReferencedName();
            }
        }
        if (CollectionsKt.contains((Iterable)immutableTypes, (Object)lhsType) && CollectionsKt.contains((Iterable)mutableTypes, rhsType)) {
            String message = "Down-casting from type " + lhsType + " to " + rhsType + " is risky.";
            if (rhsType != null && StringsKt.startsWith$default((String)rhsType, (String)"Mutable", (boolean)false, (int)2, null)) {
                message = message + " Use `to" + rhsType + "()` instead.";
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parent), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    static {
        Object[] objectArray = new String[]{"List", "Map", "Set"};
        immutableTypes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"MutableList", "MutableMap", "MutableSet", "ArrayList", "LinkedHashSet", "HashSet", "LinkedHashMap", "HashMap"};
        mutableTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DontDowncastCollectionTypes$Companion;", "", "()V", "immutableTypes", "", "", "getImmutableTypes", "()Ljava/util/List;", "mutableTypes", "getMutableTypes", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getImmutableTypes() {
            return immutableTypes;
        }

        @NotNull
        public final List<String> getMutableTypes() {
            return mutableTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

