/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "detekt-rules-errorprone"})
public final class DoubleMutabilityForCollection
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final Set<FqName> mutableTypes;

    public DoubleMutabilityForCollection(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("DoubleMutabilityForCollection", Severity.CodeSmell, "Using var with mutable collections leads to double mutability. Consider using val or immutable collection types.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ DoubleMutabilityForCollection(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitProperty(@NotNull KtProperty property) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        Object object = this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)property);
        VariableDescriptor variableDescriptor = object instanceof VariableDescriptor ? (VariableDescriptor)object : null;
        KotlinType kotlinType3 = kotlinType2 = variableDescriptor == null ? null : variableDescriptor.getType();
        if (kotlinType2 == null) {
            return;
        }
        KotlinType type = kotlinType = kotlinType2;
        FqName standardType = TypeUtilsKt.fqNameOrNull((KotlinType)type);
        if (property.isVar() && CollectionsKt.contains((Iterable)mutableTypes, (Object)standardType)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)property), (int)0, (int)2, null), "Variable " + property.getName() + " is declared as `var` with a mutable type " + standardType + ". Consider using `val` or an immutable collection type", null, null, 24, null));
        }
    }

    public DoubleMutabilityForCollection() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new FqName[]{new FqName("kotlin.collections.MutableList"), new FqName("kotlin.collections.MutableMap"), new FqName("kotlin.collections.MutableSet"), new FqName("java.util.ArrayList"), new FqName("java.util.LinkedHashSet"), new FqName("java.util.HashSet"), new FqName("java.util.LinkedHashMap"), new FqName("java.util.HashMap")};
        mutableTypes = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection$Companion;", "", "()V", "mutableTypes", "", "Lorg/jetbrains/kotlin/name/FqName;", "getMutableTypes", "()Ljava/util/Set;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<FqName> getMutableTypes() {
            return mutableTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

