/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.bugs.IgnoredReturnValue;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001b\u0010 \u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010!\u001a\u00020\"H\u0082\u0002R'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0012\u001a\u00020\u00138BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\r\u0012\u0004\b\u0014\u0010\t\u001a\u0004\b\u0015\u0010\u0016R'\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\r\u0012\u0004\b\u0019\u0010\t\u001a\u0004\b\u001a\u0010\u000b\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/IgnoredReturnValue;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreReturnValueAnnotations", "", "Lkotlin/text/Regex;", "getIgnoreReturnValueAnnotations$annotations", "()V", "getIgnoreReturnValueAnnotations", "()Ljava/util/List;", "ignoreReturnValueAnnotations$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "restrictToAnnotatedMethods", "", "getRestrictToAnnotatedMethods$annotations", "getRestrictToAnnotatedMethods", "()Z", "restrictToAnnotatedMethods$delegate", "returnValueAnnotations", "getReturnValueAnnotations$annotations", "getReturnValueAnnotations", "returnValueAnnotations$delegate", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "contains", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "detekt-rules-errorprone"})
public final class IgnoredReturnValue
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty restrictToAnnotatedMethods$delegate;
    @NotNull
    private final ReadOnlyProperty returnValueAnnotations$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreReturnValueAnnotations$delegate;

    public IgnoredReturnValue(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("IgnoredReturnValue", Severity.Defect, "This call returns a value which is ignored", Debt.Companion.getTWENTY_MINS());
        this.restrictToAnnotatedMethods$delegate = ConfigPropertyKt.config((Object)true);
        Object[] objectArray = new String[]{"*.CheckResult", "*.CheckReturnValue"};
        this.returnValueAnnotations$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object[])objectArray), (Function1)returnValueAnnotations.2.INSTANCE);
        this.ignoreReturnValueAnnotations$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object)"*.CanIgnoreReturnValue"), (Function1)ignoreReturnValueAnnotations.2.INSTANCE);
    }

    public /* synthetic */ IgnoredReturnValue(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getRestrictToAnnotatedMethods() {
        return (Boolean)this.restrictToAnnotatedMethods$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if the rule should check only annotated methods")
    private static /* synthetic */ void getRestrictToAnnotatedMethods$annotations() {
    }

    private final List<Regex> getReturnValueAnnotations() {
        return (List)this.returnValueAnnotations$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="List of glob patterns to be used as inspection annotation")
    private static /* synthetic */ void getReturnValueAnnotations$annotations() {
    }

    private final List<Regex> getIgnoreReturnValueAnnotations() {
        return (List)this.ignoreReturnValueAnnotations$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="Annotations to skip this inspection")
    private static /* synthetic */ void getIgnoreReturnValueAnnotations$annotations() {
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        AnnotationDescriptor it;
        Object element$iv;
        Object object;
        boolean bl;
        Annotations annotations;
        CallableDescriptor resultingDescriptor;
        block13: {
            CallableDescriptor callableDescriptor;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitCallExpression(expression);
            if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                return;
            }
            if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)((KtExpression)expression), (BindingContext)this.getBindingContext())) {
                return;
            }
            ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)this.getBindingContext());
            CallableDescriptor callableDescriptor2 = callableDescriptor = resolvedCall == null ? null : resolvedCall.getResultingDescriptor();
            if (callableDescriptor == null) {
                return;
            }
            resultingDescriptor = callableDescriptor;
            if ((callableDescriptor = resultingDescriptor.getReturnType()) == null ? false : TypeUtilsKt.isUnit((KotlinType)callableDescriptor)) {
                return;
            }
            annotations = resultingDescriptor.getAnnotations();
            Iterable $this$any$iv = (Iterable)annotations;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                object = $this$any$iv.iterator();
                while (object.hasNext()) {
                    element$iv = object.next();
                    it = (AnnotationDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!this.contains(this.getIgnoreReturnValueAnnotations(), it)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (this.getRestrictToAnnotatedMethods()) {
            boolean bl3;
            block14: {
                Iterable $this$none$iv = CollectionsKt.plus((Iterable)((Iterable)annotations), (Iterable)((Iterable)resultingDescriptor.getContainingDeclaration().getAnnotations()));
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    object = $this$none$iv.iterator();
                    while (object.hasNext()) {
                        element$iv = object.next();
                        it = (AnnotationDescriptor)element$iv;
                        boolean bl4 = false;
                        if (!this.contains(this.getReturnValueAnnotations(), it)) continue;
                        bl3 = false;
                        break block14;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                return;
            }
        }
        String string = (object = expression.getCalleeExpression()) == null ? null : object.getText();
        String messageText = string == null ? expression.getText() : string;
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "The call " + messageText + " is returning a value that is ignored.", null, null, 24, null));
    }

    private final boolean contains(List<Regex> $this$contains, AnnotationDescriptor annotation) {
        boolean bl;
        block4: {
            String string;
            String string2;
            Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
            FqName fqName = annotation.getFqName();
            String string3 = string2 = fqName == null ? null : fqName.asString();
            if (string2 == null) {
                return false;
            }
            String fqName2 = string = string2;
            Iterable $this$any$iv = $this$contains;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Regex it = (Regex)element$iv;
                    boolean bl2 = false;
                    if (!it.matches((CharSequence)fqName2)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public IgnoredReturnValue() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(IgnoredReturnValue.class), "restrictToAnnotatedMethods", "getRestrictToAnnotatedMethods()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(IgnoredReturnValue.class), "returnValueAnnotations", "getReturnValueAnnotations()Ljava/util/List;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(IgnoredReturnValue.class), "ignoreReturnValueAnnotations", "getIgnoreReturnValueAnnotations()Ljava/util/List;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

