/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.bugs.LateinitUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001aH\u0016R'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR!\u0010\u000e\u001a\u00020\u000f8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\r\u0012\u0004\b\u0010\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/LateinitUsage;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeAnnotatedProperties", "", "", "getExcludeAnnotatedProperties$annotations", "()V", "getExcludeAnnotatedProperties", "()Ljava/util/List;", "excludeAnnotatedProperties$delegate", "Lkotlin/properties/ReadOnlyProperty;", "ignoreOnClassesPattern", "Lkotlin/text/Regex;", "getIgnoreOnClassesPattern$annotations", "getIgnoreOnClassesPattern", "()Lkotlin/text/Regex;", "ignoreOnClassesPattern$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "properties", "", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitProperty", "property", "detekt-rules-errorprone"})
public final class LateinitUsage
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty excludeAnnotatedProperties$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOnClassesPattern$delegate;
    @NotNull
    private List<KtProperty> properties;

    public LateinitUsage(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "Usage of lateinit detected. Using lateinit for property initialization is error prone, try using constructor injection or delegation.", Debt.Companion.getTWENTY_MINS());
        this.excludeAnnotatedProperties$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), (Function1)excludeAnnotatedProperties.2.INSTANCE);
        this.ignoreOnClassesPattern$delegate = ConfigPropertyKt.config((Object)"", (Function1)ignoreOnClassesPattern.2.INSTANCE);
        boolean bl = false;
        this.properties = new ArrayList();
    }

    public /* synthetic */ LateinitUsage(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<String> getExcludeAnnotatedProperties() {
        return (List)this.excludeAnnotatedProperties$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="Allows you to provide a list of annotations that disable this check.")
    private static /* synthetic */ void getExcludeAnnotatedProperties$annotations() {
    }

    private final Regex getIgnoreOnClassesPattern() {
        return (Regex)this.ignoreOnClassesPattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="Allows you to disable the rule for a list of classes")
    private static /* synthetic */ void getIgnoreOnClassesPattern$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (KtModifierListKt.isLateinit((KtModifierListOwner)((KtModifierListOwner)property))) {
            this.properties.add(property);
        }
    }

    public void visit(@NotNull KtFile root) {
        List list;
        KtProperty it;
        Iterable $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        boolean bl = false;
        this.properties = new ArrayList();
        super.visit(root);
        AnnotationExcluder annotationExcluder = new AnnotationExcluder(root, this.getExcludeAnnotatedProperties());
        Iterable $this$filterNot$iv = this.properties;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (KtProperty)element$iv$iv;
            boolean bl2 = false;
            list = it.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"it.annotationEntries");
            if (annotationExcluder.shouldExclude(list)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        $i$f$filterNot = false;
        $this$filterNotTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl3;
            it = (KtProperty)element$iv$iv;
            boolean bl4 = false;
            list = KtPsiUtilKt.containingClass((KtElement)((KtElement)it));
            if (list == null) {
                bl3 = false;
            } else {
                String string = list.getName();
                if (string == null) {
                    bl3 = false;
                } else {
                    CharSequence charSequence = string;
                    Regex regex = this.getIgnoreOnClassesPattern();
                    boolean bl5 = false;
                    bl3 = regex.matches(charSequence);
                }
            }
            if (bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtProperty it2 = (KtProperty)element$iv;
            boolean bl6 = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it2), (int)0, (int)2, null), "Usages of lateinit should be avoided.", null, null, 24, null));
        }
    }

    public LateinitUsage() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LateinitUsage.class), "excludeAnnotatedProperties", "getExcludeAnnotatedProperties()Ljava/util/List;"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LateinitUsage.class), "ignoreOnClassesPattern", "getIgnoreOnClassesPattern()Lkotlin/text/Regex;")))};
        $$delegatedProperties = kPropertyArray;
    }
}

