/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "report", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNullable", "", "targetExpression", "Companion", "detekt-rules-errorprone"})
public final class NullableToStringCall
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName toString = new FqName("kotlin.toString");

    public NullableToStringCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "This call may return the string \"null\"", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NullableToStringCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        KtExpression ktExpression;
        KtCallExpression ktCallExpression;
        KtReferenceExpression simpleOrCallExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitSimpleNameExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.parent");
        PsiElement $this$safeAs$iv = psiElement;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtCallExpression)) {
            psiElement2 = null;
        }
        if ((psiElement = this.targetExpression((KtExpression)(simpleOrCallExpression = (ktCallExpression = (KtCallExpression)psiElement2) == null ? (KtReferenceExpression)expression : (KtReferenceExpression)ktCallExpression))) == null) {
            return;
        }
        PsiElement targetExpression = psiElement;
        KtReferenceExpression $this$safeAs$iv2 = simpleOrCallExpression;
        boolean $i$f$safeAs2 = false;
        KtReferenceExpression ktReferenceExpression = $this$safeAs$iv2;
        if (!(ktReferenceExpression instanceof KtCallExpression)) {
            ktReferenceExpression = null;
        }
        if (Intrinsics.areEqual((psiElement = (KtCallExpression)ktReferenceExpression) == null ? null : ((ktExpression = psiElement.getCalleeExpression()) == null ? null : ktExpression.getText()), (Object)"toString") && Intrinsics.areEqual((Object)((psiElement = this.descriptor((KtExpression)simpleOrCallExpression)) == null ? null : DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)psiElement))), (Object)toString)) {
            this.report(targetExpression);
        } else if (targetExpression.getParent() instanceof KtStringTemplateEntry && this.isNullable((KtExpression)targetExpression)) {
            psiElement = targetExpression.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"targetExpression.parent");
            this.report(psiElement);
        }
    }

    private final KtExpression targetExpression(KtExpression $this$targetExpression) {
        KtExpression ktExpression;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$targetExpression;
        boolean $i$f$getStrictParentOfType = false;
        KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtQualifiedExpression.class, (boolean)true);
        if (qualifiedExpression != null) {
            KtQualifiedExpression ktQualifiedExpression = qualifiedExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtQualifiedExpression it = ktQualifiedExpression;
            boolean bl3 = false;
            Object object = $i$f$getStrictParentOfType = Intrinsics.areEqual((Object)it.getSelectorExpression(), (Object)$this$targetExpression) ? ktQualifiedExpression : null;
            if ($i$f$getStrictParentOfType == null) {
                return null;
            }
            ktExpression = (KtExpression)$i$f$getStrictParentOfType;
        } else {
            ktExpression = $this$targetExpression;
        }
        KtExpression targetExpression = ktExpression;
        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)targetExpression;
        boolean $i$f$getStrictParentOfType2 = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtQualifiedExpression.class, (boolean)true) != null) {
            return null;
        }
        return targetExpression;
    }

    private final boolean isNullable(KtExpression $this$isNullable) {
        boolean bl;
        block20: {
            KotlinType element$iv2;
            KotlinType it2;
            Object object;
            PsiElement safeAccessOperation;
            PsiElement psiElement;
            KtSafeQualifiedExpression ktSafeQualifiedExpression;
            KtExpression $this$safeAs$iv = $this$isNullable;
            boolean $i$f$safeAs = false;
            KtExpression ktExpression = $this$safeAs$iv;
            if (!(ktExpression instanceof KtSafeQualifiedExpression)) {
                ktExpression = null;
            }
            if ((ktSafeQualifiedExpression = (KtSafeQualifiedExpression)ktExpression) == null) {
                psiElement = null;
            } else {
                $this$safeAs$iv = ktSafeQualifiedExpression.getOperationTokenNode();
                if ($this$safeAs$iv == null) {
                    psiElement = null;
                } else {
                    KtExpression $this$safeAs$iv2 = $this$safeAs$iv;
                    boolean $i$f$safeAs2 = false;
                    KtExpression ktExpression2 = $this$safeAs$iv2;
                    if (!(ktExpression2 instanceof PsiElement)) {
                        ktExpression2 = null;
                    }
                    psiElement = safeAccessOperation = (PsiElement)ktExpression2;
                }
            }
            if (safeAccessOperation != null) {
                boolean bl2;
                block19: {
                    Iterable $this$none$iv = this.getBindingContext().getDiagnostics().forElement(safeAccessOperation);
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv2 : $this$none$iv) {
                            Diagnostic it2 = (Diagnostic)element$iv2;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it2.getFactory(), (Object)Errors.UNNECESSARY_SAFE_CALL)) continue;
                            bl2 = false;
                            break block19;
                        }
                        bl2 = true;
                    }
                }
                return bl2;
            }
            CompilerResources $i$f$none = this.getCompilerResources();
            if ($i$f$none == null) {
                return false;
            }
            CompilerResources compilerResources = $i$f$none;
            CallableDescriptor $this$safeAs$iv2 = this.descriptor($this$isNullable);
            if ($this$safeAs$iv2 == null) {
                return false;
            }
            CallableDescriptor descriptor = $this$safeAs$iv2;
            KotlinType bl3 = descriptor.getReturnType();
            if (bl3 == null) {
                object = null;
            } else {
                KotlinType kotlinType = bl3;
                boolean bl4 = false;
                boolean bl5 = false;
                KotlinType it3 = kotlinType;
                boolean bl6 = false;
                object = it2 = KotlinTypeKt.isNullable((KotlinType)it3) ? kotlinType : null;
            }
            if (it2 == null) {
                return false;
            }
            KotlinType originalType = element$iv2 = it2;
            bl3 = (KotlinTypeInfo)this.getBindingContext().get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)$this$isNullable);
            DataFlowInfo dataFlowInfo = it2 = bl3 == null ? null : bl3.getDataFlowInfo();
            if (it2 == null) {
                return false;
            }
            KotlinType dataFlowInfo2 = it2;
            DataFlowValue dataFlowValue = compilerResources.getDataFlowValueFactory().createDataFlowValue($this$isNullable, originalType, this.getBindingContext(), (DeclarationDescriptor)descriptor);
            Set dataFlowTypes = dataFlowInfo2.getStableTypes(dataFlowValue, compilerResources.getLanguageVersionSettings());
            Iterable $this$all$iv = dataFlowTypes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv3 : $this$all$iv) {
                    KotlinType it4 = (KotlinType)element$iv3;
                    boolean bl7 = false;
                    if (KotlinTypeKt.isNullable((KotlinType)it4)) continue;
                    bl = false;
                    break block20;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void report(PsiElement element) {
        CodeSmell codeSmell = new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)element, (int)0, (int)2, null), "This call '" + element.getText() + "' may return the string \"null\".", null, null, 24, null);
        this.report((Finding)codeSmell);
    }

    private final CallableDescriptor descriptor(KtExpression $this$descriptor) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$descriptor), (BindingContext)this.getBindingContext());
        return resolvedCall == null ? null : resolvedCall.getResultingDescriptor();
    }

    public NullableToStringCall() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall$Companion;", "", "()V", "toString", "Lorg/jetbrains/kotlin/name/FqName;", "getToString", "()Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getToString() {
            return toString;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

