/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCatchBlock;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "catchClassDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "isSubclassOf", "", "detekt-rules-errorprone"})
public final class UnreachableCatchBlock
extends Rule {
    @NotNull
    private final Issue issue;

    public UnreachableCatchBlock(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Warning, "Unreachable catch block detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnreachableCatchBlock(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        boolean bl;
        block9: {
            List prevCatchClauses;
            KtCatchClause it;
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            super.visitCatchSection(catchClause);
            if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                return;
            }
            Object $this$getStrictParentOfType$iv = (PsiElement)catchClause;
            boolean $i$f$getStrictParentOfType = false;
            KtTryExpression ktTryExpression = (KtTryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtTryExpression.class, (boolean)true);
            if (ktTryExpression == null) {
                return;
            }
            KtTryExpression tryExpression = ktTryExpression;
            $this$getStrictParentOfType$iv = tryExpression.getCatchClauses();
            Intrinsics.checkNotNullExpressionValue((Object)$this$getStrictParentOfType$iv, (String)"tryExpression.catchClauses");
            Iterable $this$takeWhile$iv = (Iterable)$this$getStrictParentOfType$iv;
            boolean $i$f$takeWhile22 = false;
            ArrayList list$iv = new ArrayList();
            for (Object item$iv : $this$takeWhile$iv) {
                it = (KtCatchClause)item$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it, (Object)catchClause))) break;
                list$iv.add(item$iv);
            }
            if ((prevCatchClauses = (List)list$iv).isEmpty()) {
                return;
            }
            ClassDescriptor $i$f$takeWhile22 = this.catchClassDescriptor(catchClause);
            if ($i$f$takeWhile22 == null) {
                return;
            }
            ClassDescriptor catchClassDescriptor = $i$f$takeWhile22;
            Iterable $this$any$iv = prevCatchClauses;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KtCatchClause)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.isSubclassOf(catchClassDescriptor, it)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)catchClause), (int)0, (int)2, null), "This catch block is unreachable.", null, null, 24, null));
        }
    }

    private final ClassDescriptor catchClassDescriptor(KtCatchClause $this$catchClassDescriptor) {
        ClassDescriptor classDescriptor;
        KtTypeReference ktTypeReference;
        KtTypeReference ktTypeReference2;
        KtParameter ktParameter = $this$catchClassDescriptor.getCatchParameter();
        KtTypeReference ktTypeReference3 = ktTypeReference2 = ktParameter == null ? null : ktParameter.getTypeReference();
        if (ktTypeReference2 == null) {
            return null;
        }
        KtTypeReference typeReference = ktTypeReference = ktTypeReference2;
        ktTypeReference = (KotlinType)this.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE, (Object)typeReference);
        if (ktTypeReference == null) {
            classDescriptor = null;
        } else {
            ktTypeReference2 = ktTypeReference.getConstructor();
            if (ktTypeReference2 == null) {
                classDescriptor = null;
            } else {
                ktParameter = ktTypeReference2.getDeclarationDescriptor();
                if (ktParameter == null) {
                    classDescriptor = null;
                } else {
                    KtParameter $this$safeAs$iv = ktParameter;
                    boolean $i$f$safeAs = false;
                    KtParameter ktParameter2 = $this$safeAs$iv;
                    if (!(ktParameter2 instanceof ClassDescriptor)) {
                        ktParameter2 = null;
                    }
                    classDescriptor = (ClassDescriptor)ktParameter2;
                }
            }
        }
        return classDescriptor;
    }

    private final boolean isSubclassOf(ClassDescriptor $this$isSubclassOf, KtCatchClause catchClause) {
        ClassDescriptor classDescriptor = this.catchClassDescriptor(catchClause);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor catchClassDescriptor = classDescriptor;
        return DescriptorUtilsKt.isSubclassOf((ClassDescriptor)$this$isSubclassOf, (ClassDescriptor)catchClassDescriptor);
    }

    public UnreachableCatchBlock() {
        this(null, 1, null);
    }
}

