/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.bugs.UnusedUnaryOperator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnusedUnaryOperator;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitPrefixExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtPrefixExpression;", "detekt-rules-errorprone"})
public final class UnusedUnaryOperator
extends Rule {
    @NotNull
    private final Issue issue;

    public UnusedUnaryOperator(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "This unary operator is not used", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnusedUnaryOperator(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitPrefixExpression(@NotNull KtPrefixExpression expression) {
        KtExpression parentOrSelf;
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitPrefixExpression(expression);
            if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                return;
            }
            if (expression.getBaseExpression() == null) {
                return;
            }
            IElementType operationToken = expression.getOperationToken();
            if (!Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.PLUS) && !Intrinsics.areEqual((Object)operationToken, (Object)KtTokens.MINUS)) {
                return;
            }
            ASTNode aSTNode = expression.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"expression.node");
            Sequence $this$none$iv = SequencesKt.takeWhile((Sequence)PsiUtilsKt.leaves((ASTNode)aSTNode, (boolean)false), (Function1)visitPrefixExpression.1.INSTANCE);
            boolean $i$f$none = false;
            for (Object element$iv : $this$none$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                if (!(it instanceof PsiWhiteSpace && it.textContains('\n'))) continue;
                bl = false;
                break block8;
            }
            bl = true;
        }
        if (bl) {
            return;
        }
        PsiElement $this$getTopmostParentOfType$iv = (PsiElement)expression;
        boolean $i$f$getTopmostParentOfType = false;
        KtBinaryExpression $i$f$none = (KtBinaryExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)$this$getTopmostParentOfType$iv, KtBinaryExpression.class);
        KtExpression ktExpression = parentOrSelf = $i$f$none == null ? (KtExpression)expression : (KtExpression)$i$f$none;
        if (BindingContextUtilsKt.isUsedAsExpression((KtExpression)parentOrSelf, (BindingContext)this.getBindingContext())) {
            return;
        }
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression.getOperationReference()), (BindingContext)this.getBindingContext());
        CallableDescriptor callableDescriptor = resolvedCall == null ? null : resolvedCall.getResultingDescriptor();
        DeclarationDescriptor declarationDescriptor = $this$getTopmostParentOfType$iv = callableDescriptor instanceof DeclarationDescriptor ? (DeclarationDescriptor)callableDescriptor : null;
        if ($this$getTopmostParentOfType$iv == null) {
            return;
        }
        PsiElement operatorDescriptor = $this$getTopmostParentOfType$iv;
        if (!KotlinBuiltIns.isUnderKotlinPackage((DeclarationDescriptor)operatorDescriptor)) {
            return;
        }
        String message = "This '" + parentOrSelf.getText() + "' is not used";
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
    }

    public UnusedUnaryOperator() {
        this(null, 1, null);
    }
}

