/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.SimpleGlob;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import io.gitlab.arturbosch.detekt.rules.bugs.AvoidReferentialEquality;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R'\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\f\u0010\r\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/AvoidReferentialEquality;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "forbiddenTypePatterns", "", "Lio/gitlab/arturbosch/detekt/api/internal/SimpleGlob;", "getForbiddenTypePatterns$annotations", "()V", "getForbiddenTypePatterns", "()Ljava/util/List;", "forbiddenTypePatterns$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryExpression", "detekt-rules-errorprone"})
public final class AvoidReferentialEquality
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty forbiddenTypePatterns$delegate;

    public AvoidReferentialEquality(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("AvoidReferentialEquality", Severity.Warning, "Avoid using referential equality and prefer to use referential equality checks instead.", Debt.Companion.getFIVE_MINS());
        this.forbiddenTypePatterns$delegate = ConfigPropertyKt.config((Object)CollectionsKt.listOf((Object)"kotlin.String"), (Function1)forbiddenTypePatterns.2.INSTANCE);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final List<SimpleGlob> getForbiddenTypePatterns() {
        return (List)this.forbiddenTypePatterns$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="Specifies those types for which referential equality checks are considered a rule violation. The types are defined by a list of simple glob patterns (supporting `*` and `?` wildcards) that match the fully qualified type name.")
    private static /* synthetic */ void getForbiddenTypePatterns$annotations() {
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryExpression(expression);
        this.checkBinaryExpression(expression);
    }

    private final void checkBinaryExpression(KtBinaryExpression expression) {
        boolean bl;
        block7: {
            if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                return;
            }
            if (!Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EQEQEQ) && !Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EXCLEQEQEQ)) {
                return;
            }
            KtExpression ktExpression = expression.getLeft();
            if (ktExpression == null || (ktExpression = CallUtilKt.getType((KtExpression)ktExpression, (BindingContext)this.getBindingContext())) == null || (ktExpression = TypeUtilsKt.fqNameOrNull((KotlinType)ktExpression)) == null) {
                return;
            }
            KtExpression checkedType = ktExpression;
            String string = checkedType.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"checkedType.asString()");
            String fullyQualifiedType = string;
            Iterable $this$any$iv = this.getForbiddenTypePatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SimpleGlob it = (SimpleGlob)element$iv;
                    boolean bl2 = false;
                    if (!it.matches(fullyQualifiedType)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Checking referential equality may lead to unwanted results.", null, null, 24, null));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(AvoidReferentialEquality.class, "forbiddenTypePatterns", "getForbiddenTypePatterns()Ljava/util/List;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

