/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ElseCaseInsteadOfExhaustiveWhen;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkForElseCaseInsteadOfExhaustiveWhenExpression", "", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "isNonExpectedSealedClass", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "visitWhenExpression", "detekt-rules-errorprone"})
public final class ElseCaseInsteadOfExhaustiveWhen
extends Rule {
    @NotNull
    private final Issue issue;

    public ElseCaseInsteadOfExhaustiveWhen(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ElseCaseInsteadOfExhaustiveWhen", Severity.Warning, "A `when` expression that has an exhaustive set of cases should not contain an `else` case.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ ElseCaseInsteadOfExhaustiveWhen(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression whenExpression) {
        Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
        super.visitWhenExpression(whenExpression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        this.checkForElseCaseInsteadOfExhaustiveWhenExpression(whenExpression);
    }

    private final void checkForElseCaseInsteadOfExhaustiveWhenExpression(KtWhenExpression whenExpression) {
        block6: {
            boolean isSealedSubject;
            boolean isEnumSubject;
            block5: {
                boolean isBooleanSubject;
                KtExpression ktExpression = whenExpression.getSubjectExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression subjectExpression = ktExpression;
                if (whenExpression.getElseExpression() == null) {
                    return;
                }
                KotlinType subjectType = CallUtilKt.getType((KtExpression)subjectExpression, (BindingContext)this.getBindingContext());
                isEnumSubject = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)subjectType) != null;
                isSealedSubject = this.isNonExpectedSealedClass(subjectType);
                KotlinType kotlinType = subjectType;
                boolean bl = kotlinType != null ? TypeUtilsKt.isBooleanOrNullableBoolean((KotlinType)kotlinType) : (isBooleanSubject = false);
                if (isEnumSubject || isSealedSubject) break block5;
                if (!isBooleanSubject) break block6;
            }
            String subjectTypeName = isEnumSubject ? "enum class" : (isSealedSubject ? "sealed class" : "boolean");
            String message = "When expression with " + subjectTypeName + " subject should not contain an `else` case.";
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)whenExpression), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    private final boolean isNonExpectedSealedClass(KotlinType type) {
        ClassDescriptor sealedClassDescriptor = WhenChecker.getClassDescriptorOfTypeIfSealed((KotlinType)type);
        return sealedClassDescriptor != null && !sealedClassDescriptor.isExpect();
    }

    public ElseCaseInsteadOfExhaustiveWhen() {
        this(null, 1, null);
    }
}

