/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import io.gitlab.arturbosch.detekt.rules.bugs.EqualsAlwaysReturnsTrueOrFalse$isSingleReturnWithBooleanConstant$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\n*\u00020\u0010H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsAlwaysReturnsTrueOrFalse;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isSingleReturnWithBooleanConstant", "", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isBooleanConstant", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "returnsBooleanConstant", "detekt-rules-errorprone"})
public final class EqualsAlwaysReturnsTrueOrFalse
extends Rule {
    @NotNull
    private final Issue issue;

    public EqualsAlwaysReturnsTrueOrFalse(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("EqualsAlwaysReturnsTrueOrFalse", Severity.Defect, "Having an `equals()` method that always returns true or false is not a good idea. It does not follow the contract of this method. Consider a good default implementation (e.g. `this == other`).", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ EqualsAlwaysReturnsTrueOrFalse(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (MethodSignatureKt.isEqualsFunction((KtFunction)((KtFunction)function)) && this.returnsBooleanConstant(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), "This equals function always returns the same result regardless of the input parameters.", null, null, 24, null));
        }
    }

    private final boolean returnsBooleanConstant(KtNamedFunction $this$returnsBooleanConstant) {
        KtExpression ktExpression = $this$returnsBooleanConstant.getBodyExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression bodyExpression = ktExpression;
        return bodyExpression instanceof KtConstantExpression ? this.isBooleanConstant((PsiElement)bodyExpression) : this.isSingleReturnWithBooleanConstant(bodyExpression);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSingleReturnWithBooleanConstant(KtExpression bodyExpression) {
        KtExpression ktExpression;
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$forEachDescendantOfType$iv$iv$iv$iv2;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv2;
        void $this$collectDescendantsOfType$iv;
        PsiElement psiElement = (PsiElement)bodyExpression;
        Function1 predicate$iv = (Function1)new Function1<KtReturnExpression, Boolean>(bodyExpression){
            final /* synthetic */ KtExpression $bodyExpression;
            {
                this.$bodyExpression = $bodyExpression;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtReturnExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getParent(), (Object)this.$bodyExpression) || it.getParent() instanceof KtAnnotatedExpression && Intrinsics.areEqual((Object)it.getParent().getParent(), (Object)this.$bodyExpression);
            }
        };
        boolean $i$f$collectDescendantsOfType = false;
        void $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        Iterator iterator = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo22 = false;
        void var11_15 = $this$collectDescendantsOfTypeTo$iv$iv$iv2;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType22 = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        List returnExpressionsInBlock2 = (List)to$iv$iv$iv;
        KtReturnExpression ktReturnExpression = (KtReturnExpression)CollectionsKt.firstOrNull((List)returnExpressionsInBlock2);
        KtExpression lastValidReturnExpression = ktReturnExpression != null ? ktReturnExpression.getReturnedExpression() : null;
        PsiElement $this$collectDescendantsOfType_u24default$iv = (PsiElement)bodyExpression;
        Function1 predicate$iv2 = isSingleReturnWithBooleanConstant$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        $i$f$collectDescendantsOfType2 = false;
        PsiElement $this$collectDescendantsOfType$iv$iv2 = $this$collectDescendantsOfType_u24default$iv;
        boolean $i$f$collectDescendantsOfType3 = false;
        PsiElement $i$f$collectDescendantsOfTypeTo22 = $this$collectDescendantsOfType$iv$iv2;
        Collection to$iv$iv$iv2 = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void $i$f$forEachDescendantOfType22 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv2 = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv2, to$iv$iv$iv2){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv2){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        List allReturnExpressions = (List)to$iv$iv$iv2;
        boolean hasNoNestedReturnExpression = allReturnExpressions.size() == returnExpressionsInBlock2.size();
        KtExpression ktExpression2 = lastValidReturnExpression;
        if (ktExpression2 == null) return false;
        if (!this.isBooleanConstant((PsiElement)ktExpression2)) return false;
        boolean bl = true;
        if (!bl) return false;
        if (hasNoNestedReturnExpression) return true;
        Iterable $this$all$iv = allReturnExpressions;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl2 = false;
            ktExpression = it.getReturnedExpression();
        } while (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)lastValidReturnExpression.getText()));
        return false;
    }

    private final boolean isBooleanConstant(PsiElement $this$isBooleanConstant) {
        return Intrinsics.areEqual((Object)$this$isBooleanConstant.getNode().getElementType(), (Object)KtNodeTypes.BOOLEAN_CONSTANT);
    }

    public EqualsAlwaysReturnsTrueOrFalse() {
        this(null, 1, null);
    }
}

