/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\f\u0010\u0015\u001a\u00020\u0006*\u00020\u0014H\u0002J\f\u0010\u0016\u001a\u00020\u0006*\u00020\u0017H\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ImplicitUnitReturnType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowExplicitReturnType", "", "getAllowExplicitReturnType$annotations", "()V", "getAllowExplicitReturnType", "()Z", "allowExplicitReturnType$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "hasImplicitUnitReturnType", "isUnitExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-errorprone"})
public final class ImplicitUnitReturnType
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty allowExplicitReturnType$delegate;

    public ImplicitUnitReturnType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "Functions using expression statements have an implicit return type. Changing the type of the expression accidentally, changes the function return type. This may lead to backward incompatibility. Use a block statement to make clear this function will never return a value.", Debt.Companion.getFIVE_MINS());
        this.allowExplicitReturnType$delegate = ConfigPropertyKt.config((Object)true);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getAllowExplicitReturnType() {
        return (Boolean)this.allowExplicitReturnType$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if functions with explicit 'Unit' return type should be allowed")
    private static /* synthetic */ void getAllowExplicitReturnType$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (Intrinsics.areEqual((Object)BindingContext.EMPTY, (Object)this.getBindingContext())) {
            return;
        }
        if (this.getAllowExplicitReturnType() && function.hasDeclaredReturnType()) {
            return;
        }
        KtExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null || this.isUnitExpression(bodyExpression)) {
            return;
        }
        if (this.hasImplicitUnitReturnType(function)) {
            StringBuilder stringBuilder;
            StringBuilder $this$visitNamedFunction_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$visitNamedFunction_u24lambda_u2d0.append('\'' + function.getName() + "'  has the implicit return type 'Unit'.");
            $this$visitNamedFunction_u24lambda_u2d0.append(" Prefer using a block statement");
            if (this.getAllowExplicitReturnType()) {
                $this$visitNamedFunction_u24lambda_u2d0.append(" or specify the return type explicitly");
            }
            $this$visitNamedFunction_u24lambda_u2d0.append('.');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            String message = string;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), message, null, null, 24, null));
        }
    }

    private final boolean isUnitExpression(KtExpression $this$isUnitExpression) {
        return Intrinsics.areEqual((Object)$this$isUnitExpression.getText(), (Object)StandardNames.FqNames.unit.shortName().asString());
    }

    private final boolean hasImplicitUnitReturnType(KtNamedFunction $this$hasImplicitUnitReturnType) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$hasImplicitUnitReturnType.getBodyExpression()), (BindingContext)this.getBindingContext());
        return resolvedCall != null && (resolvedCall = resolvedCall.getResultingDescriptor()) != null && (resolvedCall = resolvedCall.getReturnType()) != null ? TypeUtilsKt.isUnit((KotlinType)resolvedCall) : false;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ImplicitUnitReturnType.class, "allowExplicitReturnType", "getAllowExplicitReturnType()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

