/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/MapGetWithNotNullAssertionOperator;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitPostfixExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtPostfixExpression;", "isMapGet", "", "detekt-rules-errorprone"})
public final class MapGetWithNotNullAssertionOperator
extends Rule {
    @NotNull
    private final Issue issue;

    public MapGetWithNotNullAssertionOperator(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MapGetWithNotNullAssertionOperator", Severity.CodeSmell, "map.get() with not-null assertion operator (!!) can result in a NullPointerException. Consider usage of map.getValue(), map.getOrDefault() or map.getOrElse() instead.", Debt.Companion.getFIVE_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitPostfixExpression(@NotNull KtPostfixExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        if (Intrinsics.areEqual((Object)expression.getOperationToken(), (Object)KtTokens.EXCLEXCL) && this.isMapGet(expression)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "map.get() with not-null assertion operator (!!)", null, null, 24, null));
        }
        super.visitPostfixExpression(expression);
    }

    private final boolean isMapGet(KtPostfixExpression $this$isMapGet) {
        CallableDescriptor callableDescriptor;
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$isMapGet.getBaseExpression()), (BindingContext)this.getBindingContext());
        return Intrinsics.areEqual(resolvedCall != null && (callableDescriptor = resolvedCall.getResultingDescriptor()) != null ? DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null, (Object)new FqName("kotlin.collections.Map.get"));
    }
}

