/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0012H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0012H\u0002J\u000e\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "report", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isNullable", "", "targetExpression", "Companion", "detekt-rules-errorprone"})
public final class NullableToStringCall
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName toString = new FqName("kotlin.toString");

    public NullableToStringCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "This call may return the string \"null\"", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NullableToStringCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        KtCallExpression ktCallExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitSimpleNameExpression(expression);
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        PsiElement psiElement = expression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"expression.parent");
        PsiElement $this$safeAs$iv = psiElement;
        boolean $i$f$safeAs = false;
        PsiElement psiElement2 = $this$safeAs$iv;
        if (!(psiElement2 instanceof KtCallExpression)) {
            psiElement2 = null;
        }
        KtCallExpression ktCallExpression2 = (KtCallExpression)psiElement2;
        KtReferenceExpression simpleOrCallExpression = ktCallExpression2 != null ? (KtReferenceExpression)ktCallExpression2 : (KtReferenceExpression)expression;
        KtExpression ktExpression = this.targetExpression((KtExpression)simpleOrCallExpression);
        if (ktExpression == null) {
            return;
        }
        KtExpression targetExpression = ktExpression;
        KtReferenceExpression $this$safeAs$iv2 = simpleOrCallExpression;
        boolean $i$f$safeAs2 = false;
        KtReferenceExpression ktReferenceExpression = $this$safeAs$iv2;
        if (!(ktReferenceExpression instanceof KtCallExpression)) {
            ktReferenceExpression = null;
        }
        if (Intrinsics.areEqual((Object)((ktCallExpression = (KtCallExpression)ktReferenceExpression) != null && (ktCallExpression = ktCallExpression.getCalleeExpression()) != null ? ktCallExpression.getText() : null), (Object)"toString")) {
            CallableDescriptor callableDescriptor = this.descriptor((KtExpression)simpleOrCallExpression);
            if (Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null), (Object)toString)) {
                this.report((PsiElement)targetExpression);
                return;
            }
        }
        if (!(targetExpression.getParent() instanceof KtStringTemplateEntry)) return;
        if (!this.isNullable(targetExpression)) return;
        PsiElement psiElement3 = targetExpression.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"targetExpression.parent");
        this.report(psiElement3);
    }

    private final KtExpression targetExpression(KtExpression $this$targetExpression) {
        KtExpression ktExpression;
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)$this$targetExpression;
        boolean $i$f$getStrictParentOfType = false;
        KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtQualifiedExpression.class, (boolean)true);
        if (qualifiedExpression != null) {
            KtQualifiedExpression ktQualifiedExpression;
            KtQualifiedExpression it = ktQualifiedExpression = qualifiedExpression;
            boolean bl = false;
            Object object = Intrinsics.areEqual((Object)it.getSelectorExpression(), (Object)$this$targetExpression) ? ktQualifiedExpression : null;
            if (object == null) {
                return null;
            }
            ktExpression = (KtExpression)object;
        } else {
            ktExpression = $this$targetExpression;
        }
        KtExpression targetExpression = ktExpression;
        PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)targetExpression;
        boolean $i$f$getStrictParentOfType2 = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtQualifiedExpression.class, (boolean)true) != null) {
            return null;
        }
        return targetExpression;
    }

    private final boolean isNullable(KtExpression $this$isNullable) {
        boolean bl;
        block19: {
            Object object;
            CallableDescriptor descriptor;
            CompilerResources compilerResources;
            block21: {
                block20: {
                    KotlinType kotlinType;
                    PsiElement safeAccessOperation;
                    PsiElement psiElement;
                    KtSafeQualifiedExpression ktSafeQualifiedExpression;
                    KtExpression $this$safeAs$iv = $this$isNullable;
                    boolean $i$f$safeAs = false;
                    KtExpression ktExpression = $this$safeAs$iv;
                    if (!(ktExpression instanceof KtSafeQualifiedExpression)) {
                        ktExpression = null;
                    }
                    if ((ktSafeQualifiedExpression = (KtSafeQualifiedExpression)ktExpression) != null && (ktSafeQualifiedExpression = ktSafeQualifiedExpression.getOperationTokenNode()) != null) {
                        KtSafeQualifiedExpression $this$safeAs$iv2 = ktSafeQualifiedExpression;
                        boolean $i$f$safeAs2 = false;
                        KtSafeQualifiedExpression ktSafeQualifiedExpression2 = $this$safeAs$iv2;
                        if (!(ktSafeQualifiedExpression2 instanceof PsiElement)) {
                            ktSafeQualifiedExpression2 = null;
                        }
                        psiElement = (PsiElement)ktSafeQualifiedExpression2;
                    } else {
                        psiElement = safeAccessOperation = null;
                    }
                    if (safeAccessOperation != null) {
                        boolean bl2;
                        block18: {
                            Iterable $this$none$iv = this.getBindingContext().getDiagnostics().forElement(safeAccessOperation);
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl2 = true;
                            } else {
                                for (Object element$iv : $this$none$iv) {
                                    Diagnostic it = (Diagnostic)element$iv;
                                    boolean bl3 = false;
                                    if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.UNNECESSARY_SAFE_CALL)) continue;
                                    bl2 = false;
                                    break block18;
                                }
                                bl2 = true;
                            }
                        }
                        return bl2;
                    }
                    CompilerResources compilerResources2 = this.getCompilerResources();
                    if (compilerResources2 == null) {
                        return false;
                    }
                    compilerResources = compilerResources2;
                    CallableDescriptor callableDescriptor = this.descriptor($this$isNullable);
                    if (callableDescriptor == null) {
                        return false;
                    }
                    descriptor = callableDescriptor;
                    object = descriptor.getReturnType();
                    if (object == null) break block20;
                    KotlinType it = kotlinType = object;
                    boolean bl4 = false;
                    object = KotlinTypeKt.isNullable((KotlinType)it) && !FlexibleTypesKt.isFlexible((KotlinType)it) ? kotlinType : null;
                    if (object != null) break block21;
                }
                return false;
            }
            KotlinType originalType = object;
            KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)this.getBindingContext().get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)$this$isNullable);
            if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getDataFlowInfo()) == null) {
                return false;
            }
            KotlinTypeInfo dataFlowInfo = kotlinTypeInfo;
            DataFlowValue dataFlowValue = compilerResources.getDataFlowValueFactory().createDataFlowValue($this$isNullable, originalType, this.getBindingContext(), (DeclarationDescriptor)descriptor);
            Set dataFlowTypes = dataFlowInfo.getStableTypes(dataFlowValue, compilerResources.getLanguageVersionSettings());
            Iterable $this$all$iv = dataFlowTypes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl5 = false;
                    if (KotlinTypeKt.isNullable((KotlinType)it)) continue;
                    bl = false;
                    break block19;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void report(PsiElement element) {
        CodeSmell codeSmell = new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)element, (int)0, (int)2, null), "This call '" + element.getText() + "' may return the string \"null\".", null, null, 24, null);
        this.report((Finding)codeSmell);
    }

    private final CallableDescriptor descriptor(KtExpression $this$descriptor) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$descriptor), (BindingContext)this.getBindingContext());
        return resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
    }

    public NullableToStringCall() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall$Companion;", "", "()V", "toString", "Lorg/jetbrains/kotlin/name/FqName;", "getToString", "()Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getToString() {
            return toString;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

