/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/CastNullableToNonNullableType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryWithTypeRHSExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nCastNullableToNonNullableType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CastNullableToNonNullableType.kt\nio/gitlab/arturbosch/detekt/rules/bugs/CastNullableToNonNullableType\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,75:1\n275#2:76\n278#2:77\n*S KotlinDebug\n*F\n+ 1 CastNullableToNonNullableType.kt\nio/gitlab/arturbosch/detekt/rules/bugs/CastNullableToNonNullableType\n*L\n60#1:76\n67#1:77\n*E\n"})
public final class CastNullableToNonNullableType
extends Rule {
    @NotNull
    private final Issue issue;

    public CastNullableToNonNullableType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Nullable type to non-null type cast is found. Consider using two assertions, `null` assertions and type cast", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ CastNullableToNonNullableType(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        void $this$ifFalse$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryWithTypeRHSExpression(expression);
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
        KtSimpleNameExpression operationReference = ktSimpleNameExpression;
        if (!Intrinsics.areEqual((Object)operationReference.getReferencedNameElementType(), (Object)KtTokens.AS_KEYWORD)) {
            return;
        }
        if (Intrinsics.areEqual((Object)expression.getLeft().getText(), (Object)KtTokens.NULL_KEYWORD.getValue())) {
            return;
        }
        KtTypeReference ktTypeReference = expression.getRight();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeRef = ktTypeReference;
        KotlinType kotlinType = (KotlinType)this.getBindingContext().get((ReadOnlySlice)BindingContext.TYPE, (Object)typeRef);
        if (kotlinType == null) {
            return;
        }
        KotlinType simpleType = kotlinType;
        boolean $this$ifTrue$iv = KotlinTypeKt.isNullable((KotlinType)simpleType);
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            return;
        }
        CompilerResources compilerResources = this.getCompilerResources();
        if (compilerResources == null) {
            return;
        }
        CompilerResources compilerResourcesNonNull = compilerResources;
        KtExpression ktExpression = expression.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"getLeft(...)");
        $i$f$ifTrue = TypeUtilsKt.isNullable((KtExpression)ktExpression, (BindingContext)this.getBindingContext(), (LanguageVersionSettings)compilerResourcesNonNull.getLanguageVersionSettings(), (DataFlowValueFactory)compilerResourcesNonNull.getDataFlowValueFactory(), (boolean)true);
        boolean $i$f$ifFalse = false;
        if ($this$ifFalse$iv == false) {
            boolean bl = false;
            return;
        }
        String message = "Use separate `null` assertion and type cast like ('(" + expression.getLeft().getText() + " ?: error(\"null assertion message\")) as " + typeRef.getText() + "') instead of '" + expression.getText() + "'.";
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)operationReference), (int)0, (int)2, null), message, null, null, 24, null));
    }

    public CastNullableToNonNullableType() {
        this(null, 1, null);
    }
}

