/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import io.gitlab.arturbosch.detekt.rules.bugs.DoubleMutabilityForCollection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR'\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\u0014\u0012\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "defaultRuleIdAliases", "", "", "getDefaultRuleIdAliases", "()Ljava/util/Set;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "mutableTypes", "Lorg/jetbrains/kotlin/name/FqName;", "getMutableTypes$annotations", "()V", "getMutableTypes", "mutableTypes$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Companion", "detekt-rules-errorprone"})
public final class DoubleMutabilityForCollection
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Set<String> defaultRuleIdAliases;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty mutableTypes$delegate;
    @NotNull
    private static final List<String> defaultMutableTypes;

    public DoubleMutabilityForCollection(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.defaultRuleIdAliases = SetsKt.setOf((Object)"DoubleMutability");
        this.issue = new Issue("DoubleMutabilityForCollection", Severity.CodeSmell, "Using var with mutable collections or values leads to double mutability. Consider using val or immutable collection or value types.", Debt.Companion.getFIVE_MINS());
        this.mutableTypes$delegate = ConfigPropertyKt.config(defaultMutableTypes, (Function1)mutableTypes.2.INSTANCE);
    }

    public /* synthetic */ DoubleMutabilityForCollection(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Set<String> getDefaultRuleIdAliases() {
        return this.defaultRuleIdAliases;
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Set<FqName> getMutableTypes() {
        return (Set)this.mutableTypes$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="Define a list of mutable types to trigger on when defined with `var`.")
    private static /* synthetic */ void getMutableTypes$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        VariableDescriptor variableDescriptor = (VariableDescriptor)this.getBindingContext().get((ReadOnlySlice)BindingContext.VARIABLE, (Object)property);
        if (variableDescriptor == null || (variableDescriptor = variableDescriptor.getType()) == null) {
            return;
        }
        VariableDescriptor type = variableDescriptor;
        FqName standardType = TypeUtilsKt.fqNameOrNull((KotlinType)type);
        if (property.isVar() && CollectionsKt.contains((Iterable)this.getMutableTypes(), (Object)standardType)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)property), (int)0, (int)2, null), "Variable " + property.getName() + " is declared as `var` with a mutable type " + standardType + ". Consider using `val` or an immutable collection or value type", null, null, 24, null));
        }
    }

    public DoubleMutabilityForCollection() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DoubleMutabilityForCollection.class, "mutableTypes", "getMutableTypes()Ljava/util/Set;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new String[]{"kotlin.collections.MutableList", "kotlin.collections.MutableMap", "kotlin.collections.MutableSet", "java.util.ArrayList", "java.util.LinkedHashSet", "java.util.HashSet", "java.util.LinkedHashMap", "java.util.HashMap"};
        defaultMutableTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DoubleMutabilityForCollection$Companion;", "", "()V", "defaultMutableTypes", "", "", "getDefaultMutableTypes", "()Ljava/util/List;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getDefaultMutableTypes() {
            return defaultMutableTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

