/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.bugs.DuplicateCaseInWhenExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Deprecated(message="Rule deprecated as compiler performs this check by default")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DuplicateCaseInWhenExpression;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nDuplicateCaseInWhenExpression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuplicateCaseInWhenExpression.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DuplicateCaseInWhenExpression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n1655#2,8:63\n1549#2:71\n1620#2,3:72\n*S KotlinDebug\n*F\n+ 1 DuplicateCaseInWhenExpression.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DuplicateCaseInWhenExpression\n*L\n46#1:63,8\n51#1:71\n51#1:72,3\n*E\n"})
public final class DuplicateCaseInWhenExpression
extends Rule {
    @NotNull
    private final Issue issue;

    public DuplicateCaseInWhenExpression(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("DuplicateCaseInWhenExpression", Severity.Warning, "Duplicated `case` statements in a `when` expression detected. Both cases should be merged.", Debt.Companion.getTEN_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List list = expression.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
        Iterable $this$distinctBy$iv = list;
        boolean $i$f$distinctBy2 = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            KtWhenEntry entry = (KtWhenEntry)e$iv;
            boolean bl = false;
            KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
            Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
            String key$iv = ArraysKt.joinToString$default((Object[])ktWhenConditionArray, null, null, null, (int)0, null, (Function1)visitWhenExpression.distinctEntries.1.1.INSTANCE, (int)31, null);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctEntries2 = list$iv;
        if (!Intrinsics.areEqual((Object)distinctEntries2, (Object)expression.getEntries())) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List list2 = expression.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getEntries(...)");
            Iterable $i$f$distinctBy2 = CollectionsKt.subtract((Iterable)list2, (Iterable)distinctEntries2);
            boolean $i$f$map = false;
            list$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void entry;
                KtWhenEntry ktWhenEntry = (KtWhenEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                KtWhenCondition[] ktWhenConditionArray = entry.getConditions();
                Intrinsics.checkNotNullExpressionValue((Object)ktWhenConditionArray, (String)"getConditions(...)");
                collection.add(ArraysKt.joinToString$default((Object[])ktWhenConditionArray, null, null, null, (int)0, null, (Function1)visitWhenExpression.duplicateEntries.1.1.INSTANCE, (int)31, null));
            }
            List duplicateEntries2 = (List)destination$iv$iv;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "When expression has multiple case statements for " + CollectionsKt.joinToString$default((Iterable)duplicateEntries2, (CharSequence)"; ", null, null, (int)0, null, null, (int)62, null) + '.', null, null, 24, null));
        }
    }
}

