/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.extapi.psi.StubBasedPsiElementBase;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u00020\n*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/IteratorNotThrowingNoSuchElementException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isNoSuchElementExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "throwsNoSuchElementExceptionThrown", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nIteratorNotThrowingNoSuchElementException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IteratorNotThrowingNoSuchElementException.kt\nio/gitlab/arturbosch/detekt/rules/bugs/IteratorNotThrowingNoSuchElementException\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,83:1\n243#2:84\n254#2,10:85\n276#2:95\n*S KotlinDebug\n*F\n+ 1 IteratorNotThrowingNoSuchElementException.kt\nio/gitlab/arturbosch/detekt/rules/bugs/IteratorNotThrowingNoSuchElementException\n*L\n76#1:84\n76#1:85,10\n76#1:95\n*E\n"})
public final class IteratorNotThrowingNoSuchElementException
extends Rule {
    @NotNull
    private final Issue issue;

    public IteratorNotThrowingNoSuchElementException(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("IteratorNotThrowingNoSuchElementException", Severity.Defect, "The `next()` method of an `Iterator` implementation should throw a `NoSuchElementException` when there are no more elements to return.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ IteratorNotThrowingNoSuchElementException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        KtNamedDeclaration nextMethod;
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        if (KtPsiUtilKt.getSuperNames((StubBasedPsiElementBase)((StubBasedPsiElementBase)classOrObject)).contains("Iterator") && (nextMethod = KtPsiUtilKt.findFunctionByName((KtClassOrObject)classOrObject, (String)"next")) != null && !this.throwsNoSuchElementExceptionThrown(nextMethod)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)classOrObject), "This implementation of Iterator does not correctly implement the next() method as it doesn't throw a NoSuchElementException when no elements remain in the Iterator.", null, null, 24, null));
        }
        super.visitClassOrObject(classOrObject);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean throwsNoSuchElementExceptionThrown(KtNamedDeclaration $this$throwsNoSuchElementExceptionThrown) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = (PsiElement)$this$throwsNoSuchElementExceptionThrown;
        Function1 predicate$iv = (Function1)new Function1<KtThrowExpression, Boolean>(this){
            final /* synthetic */ IteratorNotThrowingNoSuchElementException this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull KtThrowExpression it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return IteratorNotThrowingNoSuchElementException.access$isNoSuchElementExpression(this.this$0, it);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof KtThrowExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private final boolean isNoSuchElementExpression(KtThrowExpression expression) {
        KtExpression calleeExpression;
        KtExpression ktExpression = expression.getThrownExpression();
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        KtExpression ktExpression2 = calleeExpression = ktCallExpression != null ? ktCallExpression.getCalleeExpression() : null;
        return Intrinsics.areEqual((Object)(ktExpression2 != null ? ktExpression2.getText() : null), (Object)"NoSuchElementException");
    }

    public IteratorNotThrowingNoSuchElementException() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$isNoSuchElementExpression(IteratorNotThrowingNoSuchElementException $this, KtThrowExpression expression) {
        return $this.isNoSuchElementExpression(expression);
    }
}

