/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtBinaryExpressionKt;
import io.gitlab.arturbosch.detekt.rules.bugs.NullCheckOnMutableProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "NullCheckVisitor", "detekt-rules-errorprone"})
public final class NullCheckOnMutableProperty
extends Rule {
    @NotNull
    private final Issue issue;

    public NullCheckOnMutableProperty(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Checking nullability on a mutable property is not useful because the property may be set to null afterwards.", Debt.Companion.getTEN_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super.visitKtFile(file);
        new NullCheckVisitor().visitKtFile(file);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u0017H\u0002R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty$NullCheckVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty;)V", "candidateProperties", "", "Lorg/jetbrains/kotlin/name/FqName;", "", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "mutableProperties", "", "visitIfExpression", "", "expression", "visitPrimaryConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "visitReferenceExpression", "Lorg/jetbrains/kotlin/psi/KtReferenceExpression;", "collectNonNullChecks", "", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "detekt-rules-errorprone"})
    @SourceDebugExtension(value={"SMAP\nNullCheckOnMutableProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NullCheckOnMutableProperty.kt\nio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty$NullCheckVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,158:1\n1313#2,2:159\n1603#3,9:161\n1855#3:170\n1856#3:180\n1612#3:181\n1855#3,2:182\n1#4:171\n1#4:179\n372#5,7:172\n*S KotlinDebug\n*F\n+ 1 NullCheckOnMutableProperty.kt\nio/gitlab/arturbosch/detekt/rules/bugs/NullCheckOnMutableProperty$NullCheckVisitor\n*L\n77#1:159,2\n94#1:161,9\n94#1:170\n94#1:180\n94#1:181\n115#1:182,2\n94#1:179\n108#1:172,7\n*E\n"})
    private final class NullCheckVisitor
    extends DetektVisitor {
        @NotNull
        private final Set<FqName> mutableProperties = new LinkedHashSet();
        @NotNull
        private final Map<FqName, List<KtIfExpression>> candidateProperties = new LinkedHashMap();

        /*
         * WARNING - void declaration
         */
        public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
            super.visitPrimaryConstructor(constructor);
            Sequence sequence = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)constructor.getValueParameters()), (Function1)visitPrimaryConstructor.1.INSTANCE), (Function1)visitPrimaryConstructor.2.INSTANCE);
            Set<FqName> set = this.mutableProperties;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FqName p0 = (FqName)element$iv;
                boolean bl = false;
                set.add(p0);
            }
        }

        public void visitProperty(@NotNull KtProperty property) {
            Intrinsics.checkNotNullParameter((Object)property, (String)"property");
            super.visitProperty(property);
            FqName fqName = property.getFqName();
            if (fqName != null && (property.isVar() || property.getGetter() != null)) {
                this.mutableProperties.add(fqName);
            }
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public void visitIfExpression(@NotNull KtIfExpression expression) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            var4_2 /* !! */  = expression.getCondition();
            var3_3 = var4_2 /* !! */  instanceof KtBinaryExpression != false ? (KtBinaryExpression)var4_2 /* !! */  : null;
            v0 = var3_3 != null ? this.collectNonNullChecks(var3_3) : null;
            if (v0 == null) {
                v0 = CollectionsKt.emptyList();
            }
            nonNullChecks = v0;
            var4_2 /* !! */  = nonNullChecks;
            var5_5 = NullCheckOnMutableProperty.this;
            $i$f$mapNotNull = false;
            var7_9 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var12_14 = $this$forEach$iv$iv$iv.iterator();
            while (var12_14.hasNext()) {
                element$iv$iv = element$iv$iv$iv = var12_14.next();
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                nonNullCondition = (KtBinaryExpression)element$iv$iv;
                $i$a$-mapNotNull-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1 = false;
                v1 = nonNullCondition.getLeft() instanceof KtConstantExpression ? ((var18_20 = nonNullCondition.getRight()) instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)var18_20 : null) : (var19_21 = (var18_20 = nonNullCondition.getLeft()) instanceof KtNameReferenceExpression != false ? (KtNameReferenceExpression)var18_20 : null);
                if (var19_21 == null) ** GOTO lbl-1000
                referenceExpression = var19_21;
                $i$a$-let-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$1 = false;
                var22_24 /* !! */  = CallUtilKt.getResolvedCall((KtElement)((KtElement)referenceExpression), (BindingContext)var5_5.getBindingContext());
                if (var22_24 /* !! */  != null && (var23_25 = var22_24 /* !! */ .getResultingDescriptor()) != null) {
                    it = var23_25;
                    $i$a$-let-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$1$1 = false;
                    if (DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)it)) != null) {
                        var27_32 = this.mutableProperties;
                        p0 = var26_31;
                        $i$a$-takeIf-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$1$1$1 = false;
                        v2 /* !! */  = var27_32.contains(p0) ? var26_31 : null;
                    } else {
                        v2 /* !! */  = null;
                    }
                } else {
                    v2 /* !! */  = null;
                }
                if ((var18_20 = v2 /* !! */ ) != null) {
                    candidateFqName = var18_20;
                    $i$a$-let-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$2 = false;
                    $this$getOrPut$iv = this.candidateProperties;
                    $i$f$getOrPut = false;
                    value$iv = $this$getOrPut$iv.get(candidateFqName);
                    if (value$iv == null) {
                        $i$a$-getOrPut-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$2$1 = false;
                        answer$iv = (List)new ArrayDeque();
                        $this$getOrPut$iv.put((FqName)candidateFqName, answer$iv);
                        v3 = answer$iv;
                    } else {
                        v3 = value$iv;
                    }
                    var22_24 /* !! */  = v3;
                    $this$visitIfExpression_u24lambda_u245_u24lambda_u244_u24lambda_u243 = (List)var22_24 /* !! */ ;
                    $i$a$-apply-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$modifiedCandidateQueues$1$2$2 = false;
                    $this$visitIfExpression_u24lambda_u245_u24lambda_u244_u24lambda_u243.add(expression);
                    v4 = (List)var22_24 /* !! */ ;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = null;
                }
                if (v4 == null) continue;
                it$iv$iv = v4;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            modifiedCandidateQueues = (List)destination$iv$iv;
            super.visitIfExpression(expression);
            $this$forEach$iv = modifiedCandidateQueues;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                it = (List)element$iv;
                $i$a$-forEach-NullCheckOnMutableProperty$NullCheckVisitor$visitIfExpression$1 = false;
                UtilsKt.pop((List)it);
            }
        }

        public void visitReferenceExpression(@NotNull KtReferenceExpression expression) {
            block2: {
                FqName fqName;
                CallableDescriptor callableDescriptor;
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                super.visitReferenceExpression(expression);
                ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)expression), (BindingContext)NullCheckOnMutableProperty.this.getBindingContext());
                if (resolvedCall == null || (callableDescriptor = resolvedCall.getResultingDescriptor()) == null || (fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor))) == null) break block2;
                FqName fqName2 = fqName;
                NullCheckOnMutableProperty nullCheckOnMutableProperty = NullCheckOnMutableProperty.this;
                FqName fqName3 = fqName2;
                boolean bl = false;
                PsiElement expressionParent = expression.getParent();
                if (!(expressionParent instanceof KtBinaryExpression) || !KtBinaryExpressionKt.isNonNullCheck((KtBinaryExpression)((KtBinaryExpression)expressionParent)) && !KtBinaryExpressionKt.isNullCheck((KtBinaryExpression)((KtBinaryExpression)expressionParent))) {
                    KtIfExpression ktIfExpression = this.candidateProperties.get(fqName3);
                    if (ktIfExpression != null && (ktIfExpression = (KtIfExpression)UtilsKt.peek(ktIfExpression)) != null) {
                        KtIfExpression ifExpression = ktIfExpression;
                        boolean bl2 = false;
                        nullCheckOnMutableProperty.report((Finding)new CodeSmell(nullCheckOnMutableProperty.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)ifExpression), (int)0, (int)2, null), "Null-check is being called on mutable property '" + fqName3 + "'.", null, null, 24, null));
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<KtBinaryExpression> collectNonNullChecks(KtBinaryExpression $this$collectNonNullChecks) {
            List list;
            if (KtBinaryExpressionKt.isNonNullCheck((KtBinaryExpression)$this$collectNonNullChecks)) {
                list = CollectionsKt.listOf((Object)$this$collectNonNullChecks);
            } else {
                void var2_2;
                KtBinaryExpression it;
                List nonNullChecks = new ArrayList();
                KtExpression ktExpression = $this$collectNonNullChecks.getLeft();
                KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
                if (ktBinaryExpression != null) {
                    it = ktBinaryExpression;
                    boolean bl = false;
                    nonNullChecks.addAll((Collection)this.collectNonNullChecks(it));
                }
                ktExpression = $this$collectNonNullChecks.getRight();
                KtBinaryExpression ktBinaryExpression2 = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
                if (ktBinaryExpression2 != null) {
                    it = ktBinaryExpression2;
                    boolean bl = false;
                    nonNullChecks.addAll((Collection)this.collectNonNullChecks(it));
                }
                list = var2_2;
            }
            return list;
        }
    }
}

