/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtCallExpressionKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "report", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitSimpleNameExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "hasNullableExpression", "", "Lorg/jetbrains/kotlin/psi/KtStringTemplateEntry;", "Companion", "detekt-rules-errorprone"})
public final class NullableToStringCall
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final FqName toString = new FqName("kotlin.toString");

    public NullableToStringCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "`toString()` on nullable receiver may return the string \"null\"", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NullableToStringCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        KtExpression ktExpression;
        KtQualifiedExpression qualifiedExpression;
        KtCallExpression callExpression;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitSimpleNameExpression(expression);
        PsiElement psiElement = expression.getParent();
        KtCallExpression ktCallExpression = callExpression = psiElement instanceof KtCallExpression ? (KtCallExpression)psiElement : null;
        KtQualifiedExpression ktQualifiedExpression = qualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)(ktCallExpression != null ? (KtReferenceExpression)ktCallExpression : (KtReferenceExpression)expression)));
        if (ktQualifiedExpression != null) {
            ktExpression = (KtExpression)ktQualifiedExpression;
        } else {
            KtCallExpression ktCallExpression2 = callExpression;
            ktExpression = ktCallExpression2 != null ? (KtExpression)ktCallExpression2 : (KtExpression)expression;
        }
        PsiElement psiElement2 = ktExpression.getParent();
        KtStringTemplateEntry stringTemplateEntry = psiElement2 instanceof KtStringTemplateEntry ? (KtStringTemplateEntry)psiElement2 : null;
        KtCallExpression ktCallExpression3 = callExpression;
        boolean bl = ktCallExpression3 != null ? KtCallExpressionKt.isCalling((KtCallExpression)ktCallExpression3, (FqName)toString, (BindingContext)this.getBindingContext()) : false;
        if (bl) {
            KtQualifiedExpression ktQualifiedExpression2 = qualifiedExpression;
            this.report((PsiElement)(ktQualifiedExpression2 != null ? (KtExpression)ktQualifiedExpression2 : (KtExpression)callExpression));
        } else {
            KtStringTemplateEntry ktStringTemplateEntry = stringTemplateEntry;
            boolean bl2 = ktStringTemplateEntry != null ? this.hasNullableExpression(ktStringTemplateEntry) : false;
            if (bl2) {
                this.report((PsiElement)stringTemplateEntry);
            }
        }
    }

    private final boolean hasNullableExpression(KtStringTemplateEntry $this$hasNullableExpression) {
        KtExpression ktExpression = $this$hasNullableExpression.getExpression();
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression = ktExpression;
        CompilerResources compilerResources = super.getCompilerResources();
        if (compilerResources == null) {
            return false;
        }
        CompilerResources compilerResources2 = compilerResources;
        return TypeUtilsKt.isNullable((KtExpression)expression, (BindingContext)this.getBindingContext(), (LanguageVersionSettings)compilerResources2.getLanguageVersionSettings(), (DataFlowValueFactory)compilerResources2.getDataFlowValueFactory(), (boolean)false);
    }

    private final void report(PsiElement element) {
        CodeSmell codeSmell = new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)element, (int)0, (int)2, null), "This call '" + element.getText() + "' may return the string \"null\".", null, null, 24, null);
        this.report((Finding)codeSmell);
    }

    public NullableToStringCall() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall$Companion;", "", "()V", "toString", "Lorg/jetbrains/kotlin/name/FqName;", "getToString", "()Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FqName getToString() {
            return toString;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

