/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@RequiresTypeResolution
@Deprecated(message="Rule deprecated as compiler performs this check by default")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/RedundantElseInWhen;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhenExpression", "", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nRedundantElseInWhen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RedundantElseInWhen.kt\nio/gitlab/arturbosch/detekt/rules/bugs/RedundantElseInWhen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n533#2,6:83\n1747#2,3:89\n*S KotlinDebug\n*F\n+ 1 RedundantElseInWhen.kt\nio/gitlab/arturbosch/detekt/rules/bugs/RedundantElseInWhen\n*L\n75#1:83,6\n77#1:89,3\n*E\n"})
public final class RedundantElseInWhen
extends Rule {
    @NotNull
    private final Issue issue;

    public RedundantElseInWhen(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantElseInWhen", Severity.Warning, "Check for redundant `else` case in `when` expression when used as statement.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RedundantElseInWhen(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression whenExpression) {
        boolean bl;
        block7: {
            Object v1;
            KtWhenEntry it;
            block6: {
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                super.visitWhenExpression(whenExpression);
                List list = whenExpression.getEntries();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
                List $this$lastOrNull$iv = list;
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    it = (KtWhenEntry)element$iv;
                    boolean bl2 = false;
                    if (!it.isElse()) continue;
                    v1 = element$iv;
                    break block6;
                }
                v1 = null;
            }
            KtWhenEntry ktWhenEntry = v1;
            if (ktWhenEntry == null) {
                return;
            }
            KtWhenEntry elseEntry = ktWhenEntry;
            Collection compilerReports = this.getBindingContext().getDiagnostics().forElement((PsiElement)elseEntry);
            Iterable $this$any$iv = compilerReports;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (Diagnostic)element$iv;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.REDUNDANT_ELSE_IN_WHEN)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)whenExpression), (int)0, (int)2, null), "When expression contains redundant `else` case.", null, null, 24, null));
        }
    }

    public RedundantElseInWhen() {
        this(null, 1, null);
    }
}

