/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtCallExpressionKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Companion", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnnecessaryNotNullCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessaryNotNullCheck.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1726#2,3:74\n*S KotlinDebug\n*F\n+ 1 UnnecessaryNotNullCheck.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck\n*L\n55#1:74,3\n*E\n"})
public final class UnnecessaryNotNullCheck
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<FqName> notNullCheckFunctionFqNames;

    public UnnecessaryNotNullCheck(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryNotNullCheck", Severity.Defect, "Remove unnecessary not-null checks on non-null types.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryNotNullCheck(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        boolean bl;
        KtValueArgument argument;
        KtExpression callee;
        block8: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitCallExpression(expression);
            CompilerResources compilerResources = this.getCompilerResources();
            if (compilerResources == null) {
                return;
            }
            CompilerResources compilerResources2 = compilerResources;
            KtExpression ktExpression = expression.getCalleeExpression();
            if (ktExpression == null) {
                return;
            }
            callee = ktExpression;
            List list = expression.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.firstOrNull((List)list);
            if (ktValueArgument == null || (ktValueArgument = ktValueArgument.getArgumentExpression()) == null) {
                return;
            }
            argument = ktValueArgument;
            if (!KtCallExpressionKt.isCalling((KtCallExpression)expression, notNullCheckFunctionFqNames, (BindingContext)this.getBindingContext())) {
                return;
            }
            Set dataFlowAwareTypes = TypeUtilsKt.getDataFlowAwareTypes$default((KtExpression)argument, (BindingContext)this.getBindingContext(), (LanguageVersionSettings)compilerResources2.getLanguageVersionSettings(), (DataFlowValueFactory)compilerResources2.getDataFlowValueFactory(), null, (int)8, null);
            Iterable $this$all$iv = dataFlowAwareTypes;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (KotlinTypeKt.isNullable((KotlinType)it)) continue;
                    bl = false;
                    break block8;
                }
                bl = true;
            }
        }
        if (bl) {
            return;
        }
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Using `" + callee.getText() + "` on non-null `" + argument.getText() + "` is unnecessary", null, null, 24, null));
    }

    public UnnecessaryNotNullCheck() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new FqName[]{new FqName("kotlin.requireNotNull"), new FqName("kotlin.checkNotNull")};
        notNullCheckFunctionFqNames = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullCheck$Companion;", "", "()V", "notNullCheckFunctionFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

