/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnnecessarySafeCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitSafeQualifiedExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnnecessarySafeCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnnecessarySafeCall.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessarySafeCall\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,67:1\n154#2:68\n288#3,2:69\n*S KotlinDebug\n*F\n+ 1 UnnecessarySafeCall.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnnecessarySafeCall\n*L\n45#1:68\n53#1:69,2\n*E\n"})
public final class UnnecessarySafeCall
extends Rule {
    @NotNull
    private final Issue issue;

    public UnnecessarySafeCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessarySafeCall", Severity.Defect, "Unnecessary safe call operator detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessarySafeCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression expression) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitSafeQualifiedExpression(expression);
            PsiElement $this$getChildOfType$iv = (PsiElement)expression;
            boolean $i$f$getChildOfType22 = false;
            LeafPsiElement safeAccessElement = (LeafPsiElement)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, LeafPsiElement.class);
            if (safeAccessElement == null || !Intrinsics.areEqual((Object)safeAccessElement.getElementType(), (Object)KtTokens.SAFE_ACCESS)) {
                return;
            }
            Iterable $i$f$getChildOfType22 = this.getBindingContext().getDiagnostics().forElement((PsiElement)safeAccessElement);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Diagnostic it = (Diagnostic)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.UNNECESSARY_SAFE_CALL)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Diagnostic compilerReport = v0;
        if (compilerReport != null) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), expression.getText() + " contains an unnecessary safe call operator", null, null, 24, null));
        }
    }

    public UnnecessarySafeCall() {
        this(null, 1, null);
    }
}

