/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/CastToNullableType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitBinaryWithTypeRHSExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "detekt-rules-errorprone"})
public final class CastToNullableType
extends Rule {
    @NotNull
    private final Issue issue;

    public CastToNullableType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Use safe cast instead of unsafe cast to nullable types.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ CastToNullableType(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryWithTypeRHSExpression(expression);
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"getOperationReference(...)");
        KtSimpleNameExpression operationReference = ktSimpleNameExpression;
        if (!Intrinsics.areEqual((Object)operationReference.getReferencedNameElementType(), (Object)KtTokens.AS_KEYWORD)) {
            return;
        }
        if (Intrinsics.areEqual((Object)expression.getLeft().getText(), (Object)KtTokens.NULL_KEYWORD.getValue())) {
            return;
        }
        KtTypeReference ktTypeReference = expression.getRight();
        KtTypeElement ktTypeElement = ktTypeReference != null ? ktTypeReference.getTypeElement() : null;
        KtNullableType ktNullableType = ktTypeElement instanceof KtNullableType ? (KtNullableType)ktTypeElement : null;
        if (ktNullableType == null) {
            return;
        }
        KtNullableType nullableTypeElement = ktNullableType;
        KtTypeElement ktTypeElement2 = nullableTypeElement.getInnerType();
        String message = "Use the safe cast ('as? " + (ktTypeElement2 != null ? ktTypeElement2.getText() : null) + "') instead of 'as " + nullableTypeElement.getText() + "'.";
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)operationReference), (int)0, (int)2, null), message, null, null, 24, null));
    }

    public CastToNullableType() {
        this(null, 1, null);
    }
}

