/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIsExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DontDowncastCollectionTypes;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitIsExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtIsExpression;", "visitBinaryWithTypeRHSExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "checkForDowncast", "parent", "Lorg/jetbrains/kotlin/psi/KtExpression;", "left", "right", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Companion", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nDontDowncastCollectionTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DontDowncastCollectionTypes.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DontDowncastCollectionTypes\n+ 2 Junk.kt\nio/gitlab/arturbosch/detekt/rules/JunkKt\n*L\n1#1,100:1\n40#2:101\n*S KotlinDebug\n*F\n+ 1 DontDowncastCollectionTypes.kt\nio/gitlab/arturbosch/detekt/rules/bugs/DontDowncastCollectionTypes\n*L\n71#1:101\n*E\n"})
public final class DontDowncastCollectionTypes
extends Rule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Issue issue;
    @NotNull
    private static final List<String> immutableTypes;
    @NotNull
    private static final List<String> mutableTypes;

    public DontDowncastCollectionTypes(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("DontDowncastCollectionTypes", Severity.Warning, "Down-casting immutable collection types is breaking the collection contract.", Debt.Companion.getTEN_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIsExpression(@NotNull KtIsExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitIsExpression(expression);
        KtExpression ktExpression = (KtExpression)expression;
        KtExpression ktExpression2 = expression.getLeftHandSide();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"getLeftHandSide(...)");
        this.checkForDowncast(ktExpression, ktExpression2, expression.getTypeReference());
    }

    public void visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        super.visitBinaryWithTypeRHSExpression(expression);
        KtExpression ktExpression = (KtExpression)expression;
        KtExpression ktExpression2 = expression.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression2, (String)"getLeft(...)");
        this.checkForDowncast(ktExpression, ktExpression2, expression.getRight());
    }

    /*
     * Unable to fully structure code
     */
    private final void checkForDowncast(KtExpression parent, KtExpression left, KtTypeReference right) {
        var5_4 = CallUtilKt.getType((KtExpression)left, (BindingContext)this.getBindingContext());
        v0 = lhsType = var5_4 != null && (var6_5 = TypeUtilsKt.fqNameOrNull((KotlinType)var5_4)) != null && (var7_6 = var6_5.shortNameOrSpecial()) != null ? var7_6.asString() : null;
        if (right == null || (var6_5 = right.getTypeElement()) == null) ** GOTO lbl-1000
        var8_8 = var6_5;
        $i$f$safeAs = false;
        v1 = $this$safeAs$iv;
        if (!(v1 instanceof KtUserType)) {
            v1 = null;
        }
        if ((var7_6 = (KtUserType)v1) != null) {
            v2 = var7_6.getReferencedName();
        } else lbl-1000:
        // 2 sources

        {
            v2 = rhsType = null;
        }
        if (CollectionsKt.contains((Iterable)DontDowncastCollectionTypes.immutableTypes, lhsType) && CollectionsKt.contains((Iterable)DontDowncastCollectionTypes.mutableTypes, rhsType)) {
            message = "Down-casting from type " + lhsType + " to " + rhsType + " is risky.";
            if (rhsType != null && StringsKt.startsWith$default((String)rhsType, (String)"Mutable", (boolean)false, (int)2, null)) {
                message = message + " Use `to" + rhsType + "()` instead.";
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parent), (int)0, (int)2, null), message, null, null, 24, null));
        }
    }

    static {
        Object[] objectArray = new String[]{"List", "Map", "Set"};
        immutableTypes = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"MutableList", "MutableMap", "MutableSet", "ArrayList", "LinkedHashSet", "HashSet", "LinkedHashMap", "HashMap"};
        mutableTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/DontDowncastCollectionTypes$Companion;", "", "<init>", "()V", "immutableTypes", "", "", "getImmutableTypes", "()Ljava/util/List;", "mutableTypes", "getMutableTypes", "detekt-rules-errorprone"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> getImmutableTypes() {
            return immutableTypes;
        }

        @NotNull
        public final List<String> getMutableTypes() {
            return mutableTypes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

