/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ExplicitGarbageCollectionCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "matchesGCCall", "it", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "detekt-rules-errorprone"})
public final class ExplicitGarbageCollectionCall
extends Rule {
    @NotNull
    private final Issue issue;

    public ExplicitGarbageCollectionCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("ExplicitGarbageCollectionCall", Severity.Defect, "Don't try to be smarter than the JVM. Your code should work independently whether the garbage collector is disabled or not. If you face memory issues, try tuning the JVM options instead of relying on code itself.", Debt.Companion.getTWENTY_MINS());
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitCallExpression(@NotNull KtCallExpression expression) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)expression));
            if (ktSimpleNameExpression == null) break block0;
            KtSimpleNameExpression it = ktSimpleNameExpression;
            boolean bl = false;
            this.matchesGCCall(expression, it);
        }
    }

    private final void matchesGCCall(KtCallExpression expression, KtSimpleNameExpression it) {
        block2: {
            if (!it.textMatches((CharSequence)"gc") && !it.textMatches((CharSequence)"runFinalization")) break block2;
            KtExpression ktExpression = KtPsiUtilKt.getReceiverExpression((KtSimpleNameExpression)it);
            if (ktExpression != null) {
                KtExpression it2 = ktExpression;
                boolean bl = false;
                String string = it2.getText();
                if (Intrinsics.areEqual((Object)string, (Object)"System") || Intrinsics.areEqual((Object)string, (Object)"Runtime.getRuntime()")) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "An explicit call to the Garbage Collector as in " + it2.getText() + " should not be made.", null, null, 24, null));
                }
            }
        }
    }
}

