/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.KtExpressionKt;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.BindingContext;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/ImplicitUnitReturnType;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "allowExplicitReturnType", "", "getAllowExplicitReturnType$annotations", "()V", "getAllowExplicitReturnType", "()Z", "allowExplicitReturnType$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-rules-errorprone"})
public final class ImplicitUnitReturnType
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty allowExplicitReturnType$delegate;

    public ImplicitUnitReturnType(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "Functions using expression statements have an implicit return type. Changing the type of the expression accidentally, changes the function return type. This may lead to backward incompatibility. Use a block statement to make clear this function will never return a value.", Debt.Companion.getFIVE_MINS());
        this.allowExplicitReturnType$delegate = ConfigPropertyKt.config((Object)true);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final boolean getAllowExplicitReturnType() {
        return (Boolean)this.allowExplicitReturnType$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="if functions with explicit `Unit` return type should be allowed")
    private static /* synthetic */ void getAllowExplicitReturnType$annotations() {
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (this.getAllowExplicitReturnType() && function.hasDeclaredReturnType()) {
            return;
        }
        KtExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null || KtExpressionKt.isUnitExpression((KtExpression)bodyExpression)) {
            return;
        }
        if (MethodSignatureKt.hasImplicitUnitReturnType((KtNamedFunction)function, (BindingContext)this.getBindingContext())) {
            StringBuilder stringBuilder;
            StringBuilder $this$visitNamedFunction_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$visitNamedFunction_u24lambda_u240.append('\'' + function.getName() + "'  has the implicit return type `Unit`.");
            $this$visitNamedFunction_u24lambda_u240.append(" Prefer using a block statement");
            if (this.getAllowExplicitReturnType()) {
                $this$visitNamedFunction_u24lambda_u240.append(" or specify the return type explicitly");
            }
            $this$visitNamedFunction_u24lambda_u240.append('.');
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String message = string;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)function), message, null, null, 24, null));
        }
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ImplicitUnitReturnType.class, "allowExplicitReturnType", "getAllowExplicitReturnType()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

