/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBinaryExpression;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u000bH\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/InvalidRange;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "minimumSize", "", "visitBinaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "hasInvalidLoopRange", "", "range", "", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "([Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;)Z", "checkRangeTo", "lower", "upper", "checkDownTo", "checkUntil", "detekt-rules-errorprone"})
public final class InvalidRange
extends Rule {
    @NotNull
    private final Issue issue;
    private final int minimumSize;

    public InvalidRange(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "If a for loops condition is false before the first iteration, the loop will never get executed.", Debt.Companion.getTEN_MINS());
        this.minimumSize = 3;
    }

    public /* synthetic */ InvalidRange(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitBinaryExpression(@NotNull KtBinaryExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        PsiElement[] psiElementArray = expression.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        PsiElement[] range = psiElementArray;
        if (range.length >= this.minimumSize && this.hasInvalidLoopRange(range)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This loop will never be executed due to its expression.", null, null, 24, null));
        }
        super.visitBinaryExpression(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasInvalidLoopRange(PsiElement[] range) {
        PsiElement psiElement = range[0];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"get(...)");
        Integer lowerValue = JunkKt.getIntValueForPsiElement((PsiElement)psiElement);
        PsiElement psiElement2 = range[2];
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"get(...)");
        Integer upperValue = JunkKt.getIntValueForPsiElement((PsiElement)psiElement2);
        if (lowerValue == null) return false;
        if (upperValue == null) {
            return false;
        }
        String string = range[1].getText();
        if (string == null) return false;
        int n = -1;
        switch (string.hashCode()) {
            case 1472: {
                if (string.equals("..")) {
                    n = 1;
                }
                break;
            }
            case -1325887811: {
                if (string.equals("downTo")) {
                    n = 2;
                }
                break;
            }
            case 111443806: {
                if (string.equals("until")) {
                    n = 3;
                }
                break;
            }
            case 45692: {
                if (string.equals("..<")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                boolean bl = this.checkRangeTo(lowerValue, upperValue);
                return bl;
            }
            case 2: {
                boolean bl = this.checkDownTo(lowerValue, upperValue);
                return bl;
            }
            case 3: {
                boolean bl = this.checkUntil(lowerValue, upperValue);
                return bl;
            }
            default: {
                return false;
            }
        }
    }

    private final boolean checkRangeTo(int lower, int upper) {
        return lower > upper;
    }

    private final boolean checkDownTo(int lower, int upper) {
        return lower < upper;
    }

    private final boolean checkUntil(int lower, int upper) {
        return lower >= upper;
    }

    public InvalidRange() {
        this(null, 1, null);
    }
}

