/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.bugs.UnconditionalJumpStatementInLoop$hasJumpStatements$lambda$0$;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u000e\u001a\u00020\u000f*\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\f\u0010\u0012\u001a\u00020\u000f*\u00020\u0013H\u0002J\f\u0010\u0014\u001a\u00020\u000f*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u00020\u000f*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u000f*\u00020\u0013H\u0002J\f\u0010\u0019\u001a\u00020\u000f*\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnconditionalJumpStatementInLoop;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitLoopExpression", "", "loopExpression", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "hasJumpStatements", "", "label", "", "isJumpStatement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isFollowedByElvisJump", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isElvisJump", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "isAfterConditionalJumpStatement", "isConditionalJumpStatement", "detekt-rules-errorprone"})
@SourceDebugExtension(value={"SMAP\nUnconditionalJumpStatementInLoop.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnconditionalJumpStatementInLoop.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnconditionalJumpStatementInLoop\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,99:1\n5298#2,3:100\n5301#2,4:115\n276#3,11:103\n299#3:114\n266#3:124\n277#3,10:125\n299#3:135\n1755#4,3:119\n1251#5,2:122\n*S KotlinDebug\n*F\n+ 1 UnconditionalJumpStatementInLoop.kt\nio/gitlab/arturbosch/detekt/rules/bugs/UnconditionalJumpStatementInLoop\n*L\n67#1:100,3\n67#1:115,4\n69#1:103,11\n69#1:114\n97#1:124\n97#1:125,10\n97#1:135\n74#1:119,3\n94#1:122,2\n*E\n"})
public final class UnconditionalJumpStatementInLoop
extends Rule {
    @NotNull
    private final Issue issue;

    public UnconditionalJumpStatementInLoop(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Defect, "An unconditional jump statement in a loop is useless. The loop itself is only executed once.", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ UnconditionalJumpStatementInLoop(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitLoopExpression(@NotNull KtLoopExpression loopExpression) {
        Intrinsics.checkNotNullParameter((Object)loopExpression, (String)"loopExpression");
        PsiElement psiElement = loopExpression.getParent();
        KtLabeledExpression ktLabeledExpression = psiElement instanceof KtLabeledExpression ? (KtLabeledExpression)psiElement : null;
        if (this.hasJumpStatements(loopExpression, ktLabeledExpression != null ? ktLabeledExpression.getLabelName() : null)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)loopExpression), (int)0, (int)2, null), "This loop contains an unconditional jump expression which essentially renders it useless as it will exit the loop during the first iteration.", null, null, 24, null));
        }
        super.visitLoopExpression(loopExpression);
    }

    private final boolean hasJumpStatements(KtLoopExpression $this$hasJumpStatements, String label) {
        boolean bl;
        block9: {
            KtExpression ktExpression = $this$hasJumpStatements.getBody();
            if (ktExpression == null) {
                return false;
            }
            KtExpression body = ktExpression;
            if (body instanceof KtBlockExpression) {
                PsiElement[] psiElementArray = ((KtBlockExpression)body).getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
                Object[] objectArray = psiElementArray;
                boolean $i$f$takeWhile = false;
                ArrayList<Object> list$iv = new ArrayList<Object>();
                for (Object item$iv : objectArray) {
                    boolean bl2;
                    PsiElement it = (PsiElement)item$iv;
                    boolean bl3 = false;
                    if (label != null) {
                        Intrinsics.checkNotNull((Object)it);
                        PsiElement $this$findDescendantOfType_u24default$iv = it;
                        Function1 predicate$iv = hasJumpStatements$lambda$0$$inlined$findDescendantOfType$default$1.INSTANCE;
                        boolean $i$f$findDescendantOfType = false;
                        PsiElement $this$findDescendantOfType$iv$iv = $this$findDescendantOfType_u24default$iv;
                        boolean $i$f$findDescendantOfType2 = false;
                        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv);
                        Ref.ObjectRef result$iv$iv = new Ref.ObjectRef();
                        $this$findDescendantOfType$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv){
                            final /* synthetic */ Function1 $predicate;
                            final /* synthetic */ Ref.ObjectRef $result;
                            {
                                this.$predicate = $predicate;
                                this.$result = $result;
                            }

                            public void visitElement(PsiElement element) {
                                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                                if (element instanceof KtContinueExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                                    this.$result.element = element;
                                    this.stopWalking();
                                    return;
                                }
                                PsiElement it = element;
                                boolean bl = false;
                                super.visitElement(element);
                            }
                        });
                        KtContinueExpression labelExpression = (KtContinueExpression)((PsiElement)result$iv$iv.element);
                        bl2 = labelExpression == null || !Intrinsics.areEqual((Object)labelExpression.getLabelName(), (Object)label);
                    } else {
                        bl2 = true;
                    }
                    if (!bl2) break;
                    list$iv.add(item$iv);
                }
                Iterable iterable = list$iv;
                boolean $i$f$any = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : iterable) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl4 = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!this.isJumpStatement(it)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            } else {
                bl = this.isJumpStatement((PsiElement)body);
            }
        }
        return bl;
    }

    private final boolean isJumpStatement(PsiElement $this$isJumpStatement) {
        return $this$isJumpStatement instanceof KtReturnExpression && !this.isFollowedByElvisJump((KtReturnExpression)$this$isJumpStatement) && !this.isAfterConditionalJumpStatement($this$isJumpStatement) || $this$isJumpStatement instanceof KtBreakExpression || $this$isJumpStatement instanceof KtContinueExpression;
    }

    private final boolean isFollowedByElvisJump(KtReturnExpression $this$isFollowedByElvisJump) {
        KtExpression ktExpression = $this$isFollowedByElvisJump.getReturnedExpression();
        KtBinaryExpression ktBinaryExpression = ktExpression instanceof KtBinaryExpression ? (KtBinaryExpression)ktExpression : null;
        return ktBinaryExpression != null ? this.isElvisJump(ktBinaryExpression) : false;
    }

    private final boolean isElvisJump(KtBinaryExpression $this$isElvisJump) {
        return Intrinsics.areEqual((Object)$this$isElvisJump.getOperationToken(), (Object)KtTokens.ELVIS) && ($this$isElvisJump.getRight() instanceof KtBreakExpression || $this$isElvisJump.getRight() instanceof KtContinueExpression);
    }

    private final boolean isAfterConditionalJumpStatement(PsiElement $this$isAfterConditionalJumpStatement) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = PsiUtilsKt.siblings((PsiElement)$this$isAfterConditionalJumpStatement, (boolean)false, (boolean)false);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!this.isConditionalJumpStatement(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isConditionalJumpStatement(PsiElement $this$isConditionalJumpStatement) {
        void $this$anyDescendantOfType$iv;
        PsiElement psiElement = $this$isConditionalJumpStatement;
        Function1 predicate$iv = arg_0 -> UnconditionalJumpStatementInLoop.isConditionalJumpStatement$lambda$3(this, arg_0);
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$findDescendantOfType$iv$iv$iv);
        Ref.ObjectRef result$iv$iv$iv = new Ref.ObjectRef();
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $predicate;
                this.$result = $result;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return (PsiElement)result$iv$iv$iv.element != null;
    }

    private static final boolean isConditionalJumpStatement$lambda$3(UnconditionalJumpStatementInLoop this$0, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isJumpStatement(it);
    }

    public UnconditionalJumpStatementInLoop() {
        this(null, 1, null);
    }
}

